/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.constants.ComCamQuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.ComCamQuadBoxState;

public class ComCamQuadBoxControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String[] panelNames = new String[5];
    private static final Map<Integer, String> switchNames;
    private static final int[] nameWidths;
    private static final Map<Integer, Integer> bfrSwitchMap;
    private static final Map<Integer, Integer> mainSwitchMap;
    private static final int statusLabelWidth;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private final JPanel topPanel = new JPanel();
    private final JPanel statePanel = new JPanel();
    private final JLabel stateLabel = new JLabel("System State: ");
    private final JLabel stateStatus = new JLabel("....");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField("...");
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel[] switchPanel = new JPanel[5];
    private final JLabel[][] switchLabel = new JLabel[5][];
    private final JLabel[][] switchStatus = new JLabel[5][];
    private final ButtonGroup[][] switchBG = new ButtonGroup[5][];
    private final JRadioButton[][] switchOffRB = new JRadioButton[5][];
    private final JRadioButton[][] switchOnRB = new JRadioButton[5][];
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private double powerPeriod = 5.0;
    private static final long serialVersionUID = 1L;

    public ComCamQuadBoxControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    private void initComponents() {
        int dvc;
        this.statusPanel = new SystemStatusPanel(this.sender);
        for (int dvc2 = 0; dvc2 < 5; ++dvc2) {
            int nSwitch = ComCamQuadBoxSwitches.NUM_SWITCHES[dvc2];
            this.switchLabel[dvc2] = new JLabel[nSwitch + 1];
            this.switchStatus[dvc2] = new JLabel[nSwitch + 1];
            this.switchBG[dvc2] = new ButtonGroup[nSwitch + 1];
            this.switchOnRB[dvc2] = new JRadioButton[nSwitch + 1];
            this.switchOffRB[dvc2] = new JRadioButton[nSwitch + 1];
        }
        int[] lines = new int[5];
        for (int swId : switchNames.keySet()) {
            int line;
            int n = dvc = swId >> 8;
            lines[n] = lines[n] + 1;
            this.switchLines.put(swId, line);
            this.switchLabel[dvc][line] = UiUtilities.newLabel((String)(switchNames.get(swId) + ": "), (int)0);
            this.switchStatus[dvc][line] = UiUtilities.newLabel((String)"X", (int)statusLabelWidth);
            JRadioButton jRadioButton = this.uiUtils.newRadioButton("On", "N" + Integer.toString(swId));
            this.switchOnRB[dvc][line] = jRadioButton;
            JRadioButton on = jRadioButton;
            JRadioButton jRadioButton2 = this.uiUtils.newRadioButton("Off", "F" + Integer.toString(swId));
            this.switchOffRB[dvc][line] = jRadioButton2;
            JRadioButton off = jRadioButton2;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.switchBG[dvc][line] = buttonGroup;
            ButtonGroup bg = buttonGroup;
            bg.add(on);
            bg.add(off);
        }
        this.statePanel.add(this.stateLabel);
        this.statePanel.add(this.stateStatus);
        this.periodPanel.add(this.periodLabel);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        GridBagConstraints gbt = new GridBagConstraints();
        this.topPanel.setLayout(new GridBagLayout());
        gbt.gridx = 0;
        gbt.gridy = 0;
        this.topPanel.add((Component)this.statusPanel, gbt);
        GridBagConstraints gbs = new GridBagConstraints();
        for (dvc = 0; dvc < 5; ++dvc) {
            JPanel panel = this.switchPanel[dvc] = new JPanel();
            TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), panelNames[dvc]);
            border.setTitleColor(UiConstants.BLUE);
            panel.setBorder(border);
            panel.setLayout(new GridBagLayout());
            gbs.gridy = 0;
            gbs.insets.top = 0;
            for (int line = 0; line < this.switchLabel[dvc].length; ++line) {
                if (this.switchLabel[dvc][line] == null) continue;
                gbs.gridx = 0;
                gbs.insets.left = 4;
                gbs.insets.right = 0;
                panel.add((Component)this.switchLabel[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.left = 0;
                panel.add((Component)this.switchStatus[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.right = 4;
                panel.add((Component)this.switchOffRB[dvc][line], gbs);
                ++gbs.gridx;
                panel.add((Component)this.switchOnRB[dvc][line], gbs);
                ++gbs.gridy;
                gbs.insets.top = -4;
            }
            panel.setMinimumSize(panel.getPreferredSize());
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.topPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.switchPanel[0], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[1], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[2], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.switchPanel[3], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[4], gbc);
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.powerPeriod));
        }
    }

    private void setSwitchOn(int swId, boolean on) {
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{ComCamQuadBoxSwitches.switchIdToName.get(swId), on});
    }

    public void updateControlPanel(ComCamQuadBoxState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ComCamQuadBoxState)reply);
    }

    public void updatePanel(ComCamQuadBoxState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    public void handleRadioButton(String name) {
        boolean on = name.charAt(0) == 'N';
        int swId = Integer.valueOf(name.substring(1));
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{ComCamQuadBoxSwitches.switchIdToName.get(swId), on});
    }

    static {
        ComCamQuadBoxControlPanel.panelNames[0] = "BFR";
        ComCamQuadBoxControlPanel.panelNames[1] = "5V Clean PDU";
        ComCamQuadBoxControlPanel.panelNames[2] = "24V Clean PDU";
        ComCamQuadBoxControlPanel.panelNames[3] = "24V Dirty PDU";
        ComCamQuadBoxControlPanel.panelNames[4] = "48V Dirty PDU";
        switchNames = new LinkedHashMap<Integer, String>();
        switchNames.put(11, "5V Clean PDU");
        switchNames.put(10, "24V Clean PDU");
        switchNames.put(8, "24V Dirty PDU");
        switchNames.put(7, "48V Dirty PDU");
        switchNames.put(4, "Trim Heaters");
        switchNames.put(0, "Heater 1");
        switchNames.put(1, "Heater 2");
        switchNames.put(264, "OTM 0-A");
        switchNames.put(265, "OTM 0-B");
        switchNames.put(767, "Main");
        switchNames.put(522, "Power/Cryo HCUs");
        switchNames.put(523, "FES/Shutter HCUs");
        switchNames.put(520, "Body purge");
        switchNames.put(515, "BPU MAQ20");
        switchNames.put(521, "Gauges");
        switchNames.put(516, "Shutter");
        switchNames.put(1023, "Main");
        switchNames.put(769, "Ion Pump");
        switchNames.put(770, "Cryo turbo");
        switchNames.put(774, "Shutter brake");
        switchNames.put(1279, "Main");
        switchNames.put(1026, "CryoTel Ctrl 0");
        switchNames.put(1027, "CryoTel Ctrl 1");
        switchNames.put(1028, "CryoTel Ctrl 2");
        switchNames.put(1029, "UTC");
        switchNames.put(1030, "REB PS 0");
        nameWidths = new int[5];
        ComCamQuadBoxControlPanel.nameWidths[0] = 110;
        ComCamQuadBoxControlPanel.nameWidths[1] = 70;
        ComCamQuadBoxControlPanel.nameWidths[2] = 130;
        ComCamQuadBoxControlPanel.nameWidths[3] = 105;
        ComCamQuadBoxControlPanel.nameWidths[4] = 105;
        bfrSwitchMap = new HashMap<Integer, Integer>();
        bfrSwitchMap.put(1, 11);
        bfrSwitchMap.put(2, 10);
        bfrSwitchMap.put(3, 8);
        bfrSwitchMap.put(4, 7);
        mainSwitchMap = new HashMap<Integer, Integer>();
        mainSwitchMap.put(2, 767);
        mainSwitchMap.put(3, 1023);
        mainSwitchMap.put(4, 1279);
        statusLabelWidth = UiUtilities.maxEnumLabelWidth(SwitchState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ComCamQuadBoxControlPanel.this.statusPanel.disablePanel();
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int dvc = swId >> 8;
                int line = (Integer)ComCamQuadBoxControlPanel.this.switchLines.get(swId);
                ComCamQuadBoxControlPanel.this.switchStatus[dvc][line].setEnabled(false);
                ComCamQuadBoxControlPanel.this.switchOffRB[dvc][line].setEnabled(false);
                ComCamQuadBoxControlPanel.this.switchOnRB[dvc][line].setEnabled(false);
            }
            ComCamQuadBoxControlPanel.this.repaint();
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final ComCamQuadBoxState qs;

        UpdatePowerStatus(ComCamQuadBoxState qs) {
            this.qs = qs;
        }

        @Override
        public void run() {
            ComCamQuadBoxControlPanel.this.statusPanel.updatePanel(this.qs.getTickMillis());
            ComCamQuadBoxControlPanel.this.stateStatus.setText("RUNNING");
            ComCamQuadBoxControlPanel.this.stateStatus.setForeground(UiConstants.GREEN);
            ComCamQuadBoxControlPanel.this.periodTextField.setEnabled(true);
            ComCamQuadBoxControlPanel.this.powerPeriod = (double)this.qs.getTickMillis() / 1000.0;
            ComCamQuadBoxControlPanel.this.periodTextField.setText(String.valueOf(ComCamQuadBoxControlPanel.this.powerPeriod));
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int devc = swId >> 8;
                int line = (Integer)ComCamQuadBoxControlPanel.this.switchLines.get(swId);
                SwitchState st = this.qs.getSwitchState(swId);
                st = st == null ? SwitchState.OFFLINE : st;
                JLabel label = ComCamQuadBoxControlPanel.this.switchStatus[devc][line];
                label.setText(st.toString());
                label.setForeground(st == SwitchState.ON ? UiConstants.GREEN : (st == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
                if (st != SwitchState.OFFLINE) {
                    JRadioButton selButton = st == SwitchState.ON ? ComCamQuadBoxControlPanel.this.switchOnRB[devc][line] : ComCamQuadBoxControlPanel.this.switchOffRB[devc][line];
                    selButton.setSelected(true);
                }
                ComCamQuadBoxControlPanel.this.switchStatus[devc][line].setEnabled(true);
                ComCamQuadBoxControlPanel.this.switchOffRB[devc][line].setEnabled(true);
                ComCamQuadBoxControlPanel.this.switchOnRB[devc][line].setEnabled(true);
            }
            iterator = bfrSwitchMap.keySet().iterator();
            while (iterator.hasNext()) {
                String suffix;
                SwitchState mainSwSt;
                int devc = (Integer)iterator.next();
                SwitchState bfrSwSt = this.qs.getSwitchState((Integer)bfrSwitchMap.get(devc));
                Integer mainSwId = (Integer)mainSwitchMap.get(devc);
                SwitchState switchState = mainSwSt = mainSwId == null ? SwitchState.ON : this.qs.getSwitchState(mainSwId);
                String string = bfrSwSt != SwitchState.ON ? " (BFR off)" : (suffix = mainSwSt != SwitchState.ON ? " (Main off)" : "");
                Color color = bfrSwSt != SwitchState.ON ? UiConstants.RED : (mainSwSt != SwitchState.ON ? UiConstants.PURPLE : UiConstants.BLUE);
                JPanel panel = ComCamQuadBoxControlPanel.this.switchPanel[devc];
                TitledBorder border = (TitledBorder)panel.getBorder();
                border.setTitle(panelNames[devc] + suffix);
                border.setTitleColor(color);
            }
            ComCamQuadBoxControlPanel.this.repaint();
        }
    }
}

