/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.ui.PowerConfigPanel;
import org.lsst.ccs.subsystem.power.ui.PowerStatusPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class PowerControlPanel
extends JPanel
implements PowerStatusPanel.Parent {
    private static final String NB_SPACE = "\u00a0";
    private final JPanel btnPanel = new JPanel();
    private final JButton btCfgPower = new JButton("Configure...");
    private final JButton btCfgSave = new JButton("Save Config");
    private final JButton btPwrOn = new JButton("Turn On");
    private final JButton btPwrOff = new JButton("Turn Off");
    private final JButton btQuit = new JButton("Quit");
    private final JLabel lbMessage = new JLabel("\u00a0");
    private final JPanel mainPanel = new JPanel();
    private static final Logger LOG = Logger.getLogger((String)PowerControlPanel.class.getName());
    private final PowerStatusPanel pwrPanel;
    private final CommandSender sender;
    private String vstPower;
    private boolean commandOK = false;
    private static final long serialVersionUID = 1L;

    public PowerControlPanel(CommandSender sender, boolean noQuit) {
        this.sender = sender;
        this.pwrPanel = new PowerStatusPanel(this);
        this.initButtonPanel(noQuit);
        this.initMainPanel();
        this.initTopPanel();
    }

    @Override
    public List<PowerChanState> getPowerState() {
        if (this.vstPower != null) {
            Object resp = this.sendCommand(null, "getPowerState", new Object[0]);
            return (List)resp;
        }
        this.display("VST power subsystem not running");
        return null;
    }

    @Override
    public void powerResized() {
        Component f = this.getTopFrame();
        f.setSize(f.getPreferredSize());
    }

    public void enableSystem(String name) {
        this.vstPower = "";
        this.pwrPanel.updatePowerStatus("");
    }

    public void disableSystem() {
        this.vstPower = null;
        this.pwrPanel.updatePowerStatus(null);
    }

    public void updateControlPanel(List<PowerChanState> state) {
        this.pwrPanel.updatePowerState(state);
    }

    private void initButtonPanel(boolean noQuit) {
        this.btnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.btnPanel.add((Component)this.btCfgPower, gbc);
        this.btCfgPower.setFocusable(false);
        this.btCfgPower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.cfgPower();
            }
        });
        ++gbc.gridy;
        this.btnPanel.add((Component)this.btCfgSave, gbc);
        this.btCfgSave.setFocusable(false);
        this.btCfgSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.cfgSave();
            }
        });
        ++gbc.gridy;
        this.btnPanel.add((Component)this.btPwrOn, gbc);
        this.btPwrOn.setFocusable(false);
        this.btPwrOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.powerOn();
            }
        });
        ++gbc.gridy;
        this.btnPanel.add((Component)this.btPwrOff, gbc);
        this.btPwrOff.setFocusable(false);
        this.btPwrOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PowerControlPanel.this.powerOff();
            }
        });
        if (!noQuit) {
            ++gbc.gridy;
            this.btnPanel.add((Component)this.btQuit, gbc);
            this.btQuit.setFocusable(false);
            this.btQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PowerControlPanel.this.quit();
                }
            });
        }
    }

    private void initMainPanel() {
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.mainPanel.add((Component)this.pwrPanel, gbc);
        ++gbc.gridx;
        this.mainPanel.add((Component)this.btnPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.anchor = 11;
        this.mainPanel.add((Component)this.lbMessage, gbc);
    }

    private void initTopPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        this.add((Component)this.mainPanel, gbc);
    }

    private void cfgPower() {
        Power[] power = (Power[])this.sendCommand(null, "getPowerConfig", new Object[0]);
        if (power == null) {
            this.display("Cannot get power configuration");
            return;
        }
        if (PowerConfigPanel.edit(SwingUtilities.getWindowAncestor(this), power)) {
            this.sendCommand(null, "setPowerConfig", new Object[]{power});
        }
    }

    private void cfgSave() {
        this.sendCommand(null, "saveNamedConfig", "");
    }

    private void powerOn() {
        this.sendCommand(null, "powerOn", new Object[0]);
        if (this.commandOK) {
            this.pwrPanel.updatePowerState(null);
        }
    }

    private void powerOff() {
        this.sendCommand(null, "powerOff", new Object[0]);
        if (this.commandOK) {
            this.pwrPanel.updatePowerState(null);
        }
    }

    private void quit() {
        this.sendCommand(null, "shutdown", new Object[0]);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    private Object sendCommand(String child, String name, Object ... params) {
        this.commandOK = false;
        if (this.vstPower == null) {
            this.display("Power system not running");
            return false;
        }
        try {
            Object resp = this.sender.sendCommand(child, name, params);
            this.display(NB_SPACE);
            this.commandOK = true;
            return resp;
        }
        catch (Exception e) {
            LOG.error((Object)("Command error: " + e));
            String text = e.getMessage();
            this.display(text == null || text.isEmpty() ? e.toString() : text);
            return null;
        }
    }

    private void display(String message) {
        this.lbMessage.setText(message);
    }

    private Component getTopFrame() {
        Container c = this;
        while (!(c instanceof JFrame || c instanceof JWindow || c instanceof JDialog || c.getParent() == null)) {
            c = c.getParent();
        }
        return c;
    }
}

