/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter;

import hep.aida.IFitData;
import hep.aida.IFitFactory;
import hep.aida.IFitter;
import hep.aida.ext.IFitMethod;
import hep.aida.ext.IOptimizerFactory;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.fitter.fitdata.FitData;
import java.util.Collection;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class FitFactory
implements IFitFactory {
    public IFitData createFitData() {
        return new FitData();
    }

    public IFitter createFitter() throws IllegalArgumentException {
        return this.createFitter(null);
    }

    public IFitter createFitter(String fitterType) throws IllegalArgumentException {
        return this.createFitter(fitterType, null);
    }

    public IFitter createFitter(String fitterType, String engineType) throws IllegalArgumentException {
        return this.createFitter(fitterType, engineType, null);
    }

    public IFitter createFitter(String fitterType, String engineType, String options) throws IllegalArgumentException {
        return new Fitter(fitterType, engineType, options);
    }

    public String[] availableFitMethods() {
        Lookup.Template template = new Lookup.Template(IFitMethod.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        String[] r = new String[c.size()];
        int count = 0;
        for (IFitMethod fm : c) {
            r[count++] = fm.fitMethodNames()[0];
        }
        return r;
    }

    public String[] availableFitEngines() {
        Lookup.Template template = new Lookup.Template(IOptimizerFactory.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        String[] r = new String[c.size()];
        int count = 0;
        for (IOptimizerFactory of : c) {
            r[count++] = of.optimizerFactoryNames()[0];
        }
        return r;
    }
}

