/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAscii {
    protected final Ascii dev;

    public TestAscii() {
        this.dev = new Ascii();
    }

    public TestAscii(Ascii dev) {
        this.dev = dev;
    }

    @Command(name="setoptions", description="Set options")
    public void setOptions(@Argument(description="Device options") Ascii.Option option) {
        this.dev.setOptions(option);
    }

    @Command(name="setdefault", description="Set default open parameter")
    public void setDefaultParm(@Argument(description="Default parameter") int param) {
        this.dev.setDefaultParm(param);
    }

    @Command(name="open", description="Open connection with serial data characteristics")
    public void open(@Argument(description="Connection type: serial or ftdi") DriverConstants.ConnType type, @Argument(description="Device identifier") String ident, @Argument(description="Baud rate") int baud, @Argument(description="The number of data bits") Ascii.DataBits dbits, @Argument(description="The number of stop bits") Ascii.StopBits sbits, @Argument(description="The parity") Ascii.Parity parity, @Argument(description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        this.dev.open(type, ident, baud, Ascii.makeDataCharacteristics(dbits, sbits, parity, flow));
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(description="Device identifier") String ident, @Argument(description="Device parameter") int param) throws DriverException {
        this.dev.open(type, ident, param);
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(description="Connection type: net, serial or ftdi") DriverConstants.ConnType type, @Argument(description="Device identifier") String ident) throws DriverException {
        this.dev.open(type, ident);
    }

    @Command(name="opennet", description="Open connection to network device")
    public void openNet(@Argument(description="Host name") String host, @Argument(description="Port number") int port) throws DriverException {
        this.dev.openNet(host, port);
    }

    @Command(name="opennet", description="Open connection to network device")
    public void openNet(@Argument(description="Host name") String host) throws DriverException {
        this.dev.openNet(host);
    }

    @Command(name="openserial", description="Open connection to serial device")
    public void openSerial(@Argument(description="Device name") String devc, @Argument(description="Baud rate") int baud) throws DriverException {
        this.dev.openSerial(devc, baud);
    }

    @Command(name="openserial", description="Open connection to serial device")
    public void openSerial(@Argument(description="Device name") String devc) throws DriverException {
        this.dev.openSerial(devc);
    }

    @Command(name="openftdi", description="Open connection to FTDI device")
    public void openFtdi(@Argument(description="USB serial number") String serial, @Argument(description="Baud rate") int baud) throws DriverException {
        this.dev.openFtdi(serial, baud);
    }

    @Command(name="openftdi", description="Open connection to FTDI device")
    public void openFtdi(@Argument(description="USB serial number") String serial) throws DriverException {
        this.dev.openFtdi(serial);
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(name="write", description="Write command to device")
    public void write(@Argument(description="Command word") String command, String ... args) throws DriverException {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(" ").append(arg);
        }
        this.dev.write(TestAscii.makeCommandString(command, args));
    }

    @Command(name="read", description="Read response from device")
    public String read() throws DriverException {
        return this.dev.read();
    }

    @Command(name="read", description="Write command and read response")
    public String read(@Argument(description="Command word") String command, String ... args) throws DriverException {
        return this.dev.read(TestAscii.makeCommandString(command, args));
    }

    @Command(name="settimeout", description="Set read response timeout")
    public void setTimeout(@Argument(description="Timeout value (msec)") int time) throws DriverException {
        this.dev.setTimeout(time);
    }

    @Command(name="showtimeout", description="Show read response timeout (msec)")
    public int showTimeout() {
        return this.dev.getTimeout();
    }

    @Command(name="setconntimeout", description="Set network connection timeout")
    public void setConnTimeout(@Argument(description="Timeout value (msec)") int time) {
        this.dev.setConnTimeout(time);
    }

    @Command(name="showconntimeout", description="Show network connection timeout (msec)")
    public int showConnTimeout() {
        return this.dev.getConnTimeout();
    }

    @Command(name="setcmndterm", description="Set command terminator")
    public void setCmndTerm(@Argument(description="Terminator enum") Ascii.Terminator term) {
        this.dev.setCommandTerm(term);
    }

    @Command(name="setrespterm", description="Set response terminator")
    public void setRespTerm(@Argument(description="Terminator enum") Ascii.Terminator term) {
        this.dev.setResponseTerm(term);
    }

    @Command(name="setterm", description="Set both terminators")
    public void setTerminator(@Argument(description="Terminator enum") Ascii.Terminator term) {
        this.dev.setTerminator(term);
    }

    protected static String makeCommandString(String command, String ... args) {
        StringBuilder cmnd = new StringBuilder(command);
        for (String arg : args) {
            cmnd.append(' ').append(arg);
        }
        return cmnd.toString();
    }
}

