/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.common.ui.MonitorTaskLine;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class MonitorTaskPanel
extends JPanel {
    private final CommandSender sender;
    private final String node;
    private final JPanel taskPanel;
    private int numTasks = 0;
    private MonitorTaskLine[] taskLines = new MonitorTaskLine[0];
    private static final long serialVersionUID = 1L;

    public MonitorTaskPanel(String title, CommandSender sender, String node) {
        this.sender = sender;
        this.node = node;
        this.taskPanel = title != null && !title.isEmpty() ? UiUtilities.newBorderedPanel(title) : new JPanel();
        this.add(this.taskPanel);
    }

    public void initPanel(List<MonitorTask> tasks) {
        for (MonitorTaskLine line : this.taskLines) {
            this.taskPanel.remove(line);
        }
        this.numTasks = tasks.size();
        this.taskLines = new MonitorTaskLine[this.numTasks];
        if (this.numTasks == 0) {
            return;
        }
        int nameLength = 0;
        for (MonitorTask task : tasks) {
            nameLength = Math.max(nameLength, UiUtilities.getLabelSize((String)task.getName()).width);
        }
        for (MonitorTask task : tasks) {
            this.taskLines[task.getIndex()] = new MonitorTaskLine(this.sender, this.node, nameLength);
        }
        this.taskPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        for (int j = 0; j < this.numTasks; ++j) {
            gbm.insets.bottom = j == this.numTasks - 1 ? 4 : 0;
            this.taskPanel.add((Component)this.taskLines[j], gbm);
            ++gbm.gridy;
        }
    }

    public void updatePanel(List<MonitorTask> tasks) {
        for (MonitorTask task : tasks) {
            this.taskLines[task.getIndex()].updatePanel(task);
        }
    }

    public void disablePanel() {
        for (MonitorTaskLine line : this.taskLines) {
            line.disablePanel();
        }
    }
}

