/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class Pdu5V
extends PduCommon {
    public static final int CHAN_SPARE_0 = 0;
    public static final int CHAN_SPARE_1 = 1;
    public static final int CHAN_SPARE_2 = 2;
    public static final int CHAN_SPARE_3 = 3;
    public static final int CHAN_SPARE_4 = 4;
    public static final int CHAN_SPARE_5 = 5;
    public static final int CHAN_OTM_0_A = 8;
    public static final int CHAN_OTM_0_B = 9;
    public static final int CHAN_OTM_1_A = 10;
    public static final int CHAN_OTM_1_B = 11;
    public static final int CHAN_OTM_2_A = 12;
    public static final int CHAN_OTM_2_B = 13;
    public static final int CHAN_OTM_3_A = 14;
    public static final int CHAN_OTM_3_B = 15;
    public static final int CHAN_OTM_4_A = 16;
    public static final int CHAN_OTM_4_B = 17;
    public static final int CHAN_OTM_5_A = 18;
    public static final int CHAN_OTM_5_B = 19;
    public static final int NUM_CHANS = 20;
    private static final Map<String, Integer> CHANNEL_MAP = new HashMap<String, Integer>();
    private static final List<Srp.BoardType> VALID_TYPES;
    private static final int VALID_CHAN_MASK = 1048383;
    private static final double SHUNT_SPARE = 0.0128;
    private static final double SHUNT_OTM = 0.0512;
    private static final double[] CURR_SCALES;

    public Pdu5V() {
        this.setValidBoardTypes(VALID_TYPES);
        this.setValidChannels(1048383);
        this.setCurrentScales(CURR_SCALES);
        this.setChannelMap(CHANNEL_MAP);
    }

    @Override
    public void powerOn(int chan) throws DriverException {
        super.powerOn(chan);
        if (chan >= 8 && chan <= 19) {
            this.powerOff(chan ^ 1);
        }
    }

    @Override
    public void powerOn(String chan) throws DriverException {
        super.powerOn(chan);
        int iChan = CHANNEL_MAP.get(chan);
        if (iChan >= 8 && iChan <= 19) {
            this.powerOff(iChan ^ 1);
        }
    }

    static {
        CHANNEL_MAP.put("spare0", 0);
        CHANNEL_MAP.put("spare1", 1);
        CHANNEL_MAP.put("spare2", 2);
        CHANNEL_MAP.put("spare3", 3);
        CHANNEL_MAP.put("spare4", 4);
        CHANNEL_MAP.put("spare5", 5);
        CHANNEL_MAP.put("otm0a", 8);
        CHANNEL_MAP.put("otm0b", 9);
        CHANNEL_MAP.put("otm1a", 10);
        CHANNEL_MAP.put("otm1b", 11);
        CHANNEL_MAP.put("otm2a", 12);
        CHANNEL_MAP.put("otm2b", 13);
        CHANNEL_MAP.put("otm3a", 14);
        CHANNEL_MAP.put("otm3b", 15);
        CHANNEL_MAP.put("otm4a", 16);
        CHANNEL_MAP.put("otm4b", 17);
        CHANNEL_MAP.put("otm5a", 18);
        CHANNEL_MAP.put("otm5b", 19);
        VALID_TYPES = new ArrayList<Srp.BoardType>();
        VALID_TYPES.add(Srp.BoardType.PDU_5V);
        VALID_TYPES.add(Srp.BoardType.SIMULATED);
        CURR_SCALES = new double[20];
        Pdu5V.CURR_SCALES[0] = 78.125;
        Pdu5V.CURR_SCALES[1] = 78.125;
        Pdu5V.CURR_SCALES[2] = 78.125;
        Pdu5V.CURR_SCALES[3] = 78.125;
        Pdu5V.CURR_SCALES[4] = 78.125;
        Pdu5V.CURR_SCALES[5] = 78.125;
        Pdu5V.CURR_SCALES[8] = 19.53125;
        Pdu5V.CURR_SCALES[9] = 19.53125;
        Pdu5V.CURR_SCALES[10] = 19.53125;
        Pdu5V.CURR_SCALES[11] = 19.53125;
        Pdu5V.CURR_SCALES[12] = 19.53125;
        Pdu5V.CURR_SCALES[13] = 19.53125;
        Pdu5V.CURR_SCALES[14] = 19.53125;
        Pdu5V.CURR_SCALES[15] = 19.53125;
        Pdu5V.CURR_SCALES[16] = 19.53125;
        Pdu5V.CURR_SCALES[17] = 19.53125;
        Pdu5V.CURR_SCALES[18] = 19.53125;
        Pdu5V.CURR_SCALES[19] = 19.53125;
    }
}

