package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.*;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;

/**
 * 
 *
 * @author The LSST CCS Team
 */
public class RebPowerStateFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final MonitorFormat FORMAT = new RebPowerStateFormatter();
    
    private final String agent;

// -- Life cycle : -------------------------------------------------------------
    
    public RebPowerStateFilter(String agent, String pdus) {
        this.agent = agent;
    }
    
    public RebPowerStateFilter(AgentInfo agent) {
        this.agent = agent.getName();
    }

    
// -- Filtering : --------------------------------------------------------------
    
    @Override
    public String getName() {
        return agent;
    }

    @Override
    public List<String> getAgents() {
        return Collections.singletonList(agent);
    }

    @Override
    public List<String> getOriginChannels() {
        ArrayList<String> selectors = new ArrayList<>();
        for ( int i = 0; i < 5; i++ ) {
            for ( int j = 0; j < 5; j++ ) {
                selectors.add("/state/R"+i+j+"/");
            }
        }
        return selectors;
    }

    @Override
    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }

    @Override
    public String getDisplayPath(String originPath) {
        String dp = originPath.replaceFirst(agent +"/", "");
        dp = dp.replaceFirst("state/", "");
//        int i = dp.indexOf("/PduOutletState");
//        if (i != -1) {
//            dp = dp.substring(0, i);
//            i = dp.lastIndexOf("/");
//            dp = dp.substring(0,i)+"/Outlets"+dp.substring(i);
//        }
        return dp;
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Arrays.asList(new String[] {MonitorField.VALUE.getKey(), MonitorField.DESCR.getKey()});
    }
    
    
    
}
