/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationParameterType;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.utilities.constraints.Constraints;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.structs.ViewValue;

public class ConfigurationParameterHandler
implements Comparable<ConfigurationParameterHandler> {
    private final ParameterPath parameterPath;
    private final ConfigurationParameter annotation;
    private final Method parameterChangerMethod;
    private final Field parameterField;
    private final Object target;
    private final ConfigurationParameterType configType;
    private final boolean hasLength;
    private String externalCategory = null;
    private ConfigurationParameterDescription configurationParameterDescription;

    ConfigurationParameterHandler(String componentName, Method m, Field f, Object target, ConfigurationParameterDescription parDescription) {
        String tmpParName;
        this.parameterChangerMethod = m;
        this.parameterField = f;
        this.target = target;
        this.parameterField.setAccessible(true);
        this.annotation = f.getAnnotation(ConfigurationParameter.class);
        this.configurationParameterDescription = parDescription;
        String string = tmpParName = this.annotation.name().isEmpty() ? f.getName() : this.annotation.name();
        if (this.configurationParameterDescription != null && this.configurationParameterDescription.getName() != null) {
            tmpParName = this.configurationParameterDescription.getName();
        }
        this.parameterPath = new ParameterPath(componentName, tmpParName);
        this.configType = this.annotation.isFinal() ? ConfigurationParameterType.FINAL : (this.annotation.isBuild() ? ConfigurationParameterType.BUILD : (this.annotation.isReadOnly() ? ConfigurationParameterType.READ_ONLY : ConfigurationParameterType.RUNTIME));
        Class<?> type = this.parameterField.getType();
        this.hasLength = type.isArray() || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    void invokeSetParameter(Object arg) {
        Method m = this.parameterChangerMethod;
        try {
            if (m != null) {
                m.setAccessible(true);
                m.invoke(this.target, arg);
            } else {
                Field f = this.parameterField;
                f.setAccessible(true);
                f.set(this.target, arg);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            String msg = cause == null ? ex.toString() : ex.getCause().getMessage();
            throw new RuntimeException("at parameter " + this.parameterPath + " : " + msg, ex);
        }
    }

    void acceptValue(Object obj) {
        if (this.hasLength && this.getMaxLength() > 0) {
            if (obj == null) {
                throw new IllegalArgumentException("Null value for field " + this.parameterField.getName() + ". Make sure to initialize the field.");
            }
            Class<?> type = this.parameterField.getType();
            int objectSize = -1;
            if (type.isArray()) {
                objectSize = Array.getLength(obj);
            } else if (Collection.class.isAssignableFrom(type)) {
                objectSize = ((Collection)obj).size();
            } else if (Map.class.isAssignableFrom(type)) {
                objectSize = ((Map)obj).size();
            }
            if (objectSize > this.getMaxLength()) {
                throw new RuntimeException("Size of committed value (" + objectSize + ") exceeds the maximum length:" + this.getMaxLength());
            }
        }
    }

    public ParameterPath getParameterPath() {
        return this.parameterPath;
    }

    public String getCategory() {
        if (this.externalCategory != null) {
            return this.externalCategory;
        }
        if (this.configurationParameterDescription != null && this.configurationParameterDescription.getCategory() != null) {
            return this.configurationParameterDescription.getCategory();
        }
        return this.annotation.category();
    }

    void setCategory(String category) {
        this.externalCategory = category;
    }

    public boolean hasConfigChangerMethod() {
        return this.parameterChangerMethod != null;
    }

    public Method getConfigChangerMethod() {
        return this.parameterChangerMethod;
    }

    public boolean isFinal() {
        return this.configType == ConfigurationParameterType.FINAL;
    }

    public boolean isReadOnly() {
        return this.configType == ConfigurationParameterType.READ_ONLY;
    }

    public boolean isBuild() {
        return this.configType == ConfigurationParameterType.BUILD;
    }

    public ConfigurationParameterType getParameterType() {
        return this.configType;
    }

    public boolean isOptional() {
        return this.annotation.isOptional();
    }

    public String getUnits() {
        return this.annotation.units();
    }

    String getDescription() {
        if (this.configurationParameterDescription != null && this.configurationParameterDescription.getDescription() != null) {
            return this.configurationParameterDescription.getDescription();
        }
        return this.annotation.description();
    }

    String getRange() {
        return this.annotation.range();
    }

    public final void checkAgainstConstraints(Object val) {
        String range = this.annotation.range();
        if (range != null) {
            try {
                Constraints.check((Object)val, (String)range);
            }
            catch (Exception e) {
                throw new RuntimeException("Range check failed for parameter " + this.getParameterPath(), e);
            }
        }
    }

    String getParameterName() {
        return this.parameterPath.getParameterName();
    }

    String getComponentName() {
        return this.parameterPath.getComponentName();
    }

    Type getType() {
        return this.parameterField.getGenericType();
    }

    final Field getField() {
        return this.parameterField;
    }

    final int getMaxLength() {
        return this.annotation.maxLength();
    }

    final boolean hasLength() {
        return this.hasLength;
    }

    final String getValue() {
        return TypeUtils.stringify((Object)this.getObjectValue());
    }

    private Object getObjectValue() {
        Object res;
        try {
            this.parameterField.setAccessible(true);
            res = this.parameterField.get(this.target);
            this.parameterField.setAccessible(false);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("could not access " + this.parameterField.getName(), ex);
        }
        return res;
    }

    ViewValue convert(String strValue) {
        try {
            Object val = InputConversionEngine.convertArgToType((String)strValue, (Type)this.parameterField.getGenericType());
            return new ViewValue(strValue, val);
        }
        catch (TypeConversionException ex) {
            throw new IllegalArgumentException("failure converting : " + this.parameterPath.toString() + " with value " + strValue + " to type " + this.parameterField.getGenericType().getTypeName(), ex);
        }
    }

    @Override
    public int compareTo(ConfigurationParameterHandler o) {
        return this.getParameterPath().compareTo((Object)o.getParameterPath());
    }
}

