/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.jas;

import java.time.Duration;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.services.command.CommandService;

public class CommandSender {
    private final String dest;
    private final CommandService sender = new CommandService();
    private int defTimeout = 5000;

    public CommandSender(String dest) {
        this.dest = dest;
    }

    public Object sendCommand(String path, String cmnd, Object ... args) {
        return this.sendCommand(this.defTimeout, path, cmnd, args);
    }

    public Object sendCommand(int timeout, String path, String cmnd, Object ... args) {
        try {
            return this.sendCommandRaw(timeout, path, cmnd, args);
        }
        catch (Exception e) {
            Console.getConsole().getLoggerUI().error((Object)"Command error: ", (Throwable)e);
            return null;
        }
    }

    public Object sendCommandRaw(String path, String cmnd, Object ... args) throws Exception {
        return this.sendCommandRaw(this.defTimeout, path, cmnd, args);
    }

    public Object sendCommandRaw(int timeout, String path, String cmnd, Object ... args) throws Exception {
        String cmd = this.dest + (path == null ? "" : "/" + path) + "/" + cmnd;
        return this.sender.execute(Duration.ofMillis(timeout), cmd, args).get();
    }

    public void setTimeout(int timeout) {
        this.defTimeout = timeout;
    }
}

