/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView3;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.fpmap.AbstractFocalPlaneMapModel;
import org.lsst.ccs.subsystem.common.ui.focalplane.fpmap.FocalPlaneMap;
import org.lsst.ccs.subsystem.common.ui.focalplane.fpmap.FocalPlaneMapModelEvent;
import org.lsst.ccs.subsystem.common.ui.focalplane.fpmap.FocalPlaneMapValue;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.FocalPlaneView;

public class MapView
extends AbstractMonitorView3
implements FocalPlaneView {
    private static final String FILTER = "Filter...";
    private static final Color COLOR_ALARM = Color.RED;
    private static final Color COLOR_WARNING = Color.ORANGE;
    private static final Color COLOR_NOMINAL = new Color(0, 200, 0);
    private static final int RGB_WARNING = COLOR_WARNING.getRGB() & 0xFFFFFF;
    private static final int RGB_NOMINAL = COLOR_NOMINAL.getRGB() & 0xFFFFFF;
    private final Descriptor descriptor;
    private FocalPlaneFilter filter;
    private boolean installed = false;
    private final Model model;
    private final Region panel;

    @Create(category="FocalPlaneView", name="Focal Plane Map", path="Built-In/Map/Single", description="Focal plane color coded map, one per page.")
    public MapView() {
        this.descriptor = new Descriptor();
        this.model = new Model();
        this.panel = new Region();
    }

    public MapView(Descriptor desc) {
        this.descriptor = desc.clone();
        this.model = new Model();
        this.panel = new Region();
        FocalPlaneFilter.Descriptor filterDescriptor = desc.getFilter();
        if (filterDescriptor != null) {
            PersistenceService service = (PersistenceService)Console.getConsole().getSingleton(PersistenceService.class);
            this.filter = (FocalPlaneFilter)service.make((Persistable.Descriptor)filterDescriptor);
        }
    }

    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public FocalPlaneFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AgentChannelsFilter filter) {
        boolean isInstalled = this.installed;
        if (isInstalled) {
            this.uninstall();
        }
        this.filter = (FocalPlaneFilter)filter;
        this.descriptor.setFilter(this.filter.save());
        if (isInstalled) {
            this.install();
        }
    }

    public void install() {
        if (!this.installed) {
            super.install();
            this.installed = true;
        }
    }

    public void uninstall() {
        if (this.installed) {
            super.uninstall();
            this.model.clear();
            this.data.clear();
            this.panel.setGroups(null, null);
            this.installed = false;
        }
    }

    private void onGroupSelection(String group) {
        FocalPlaneFilter f = null;
        if (group == null || group.isEmpty()) {
            this.descriptor.setSelection(null);
            this.model.clear();
        } else if (FILTER.equals(group)) {
            PersistenceService service = (PersistenceService)Console.getConsole().getSingleton(PersistenceService.class);
            try {
                f = this.filter == null ? (FocalPlaneFilter)service.make((Persistable.Descriptor)this.descriptor.getFilter(), null, (Component)this.panel, "FocalPlaneFilter") : (FocalPlaneFilter)service.edit((Persistable)this.filter, null, (Component)this.panel);
            }
            catch (CancellationException cancellationException) {
            }
            catch (RuntimeException x) {
                Console.getConsole().error("Failed to create the filter", (Exception)x);
            }
            if (f == null) {
                this.panel.setSelectedGroup(this.descriptor.getSelection());
            } else {
                this.setFilter((AgentChannelsFilter)f);
            }
        } else {
            this.descriptor.setSelection(group);
            this.model.rebuild();
        }
    }

    protected void resetChannels() {
        String selection;
        List<String> groups = this.getGroups();
        if (groups == null) {
            groups = Collections.emptyList();
        }
        if (!groups.contains(selection = this.descriptor.getSelection())) {
            selection = groups.isEmpty() ? null : groups.get(0);
        }
        this.panel.setGroups(groups, selection);
        this.onGroupSelection(selection);
    }

    protected void update() {
        this.model.fireEvent();
    }

    private FocalPlaneMapValue format(Cell cell) {
        if (cell.getChannels().isEmpty()) {
            cell.setFormattedValue(FocalPlaneMapValue.NONE);
            return FocalPlaneMapValue.NONE;
        }
        FocalPlaneMapValue parentValue = FocalPlaneMapValue.NONE;
        Cell parent = cell.parent;
        while (parentValue == FocalPlaneMapValue.NONE && parent != null) {
            parentValue = parent.getFormattedValue();
            if (parentValue == null) {
                this.format(parent);
                parentValue = parent.getFormattedValue();
            }
            parent = parent.parent;
        }
        FocalPlaneMapValue fv = new FocalPlaneMapValue();
        fv.setSplit(cell.children != null);
        fv.bgColor = parentValue == FocalPlaneMapValue.NONE ? null : parentValue.getBgColor();
        List originalChannels = cell.getChannels().stream().flatMap(dc -> dc.getChannels().stream()).collect(Collectors.toList());
        if (fv.bgColor == null && originalChannels.size() == 1) {
            AgentChannel channel = (AgentChannel)originalChannels.get(0);
            if (channel == null) {
                fv.bgColor = MonitorFormat.COLOR_OFF;
            } else {
                fv.toolTip = "<html>" + channel.getPath() + "<br>" + channel.get();
                fv.bgColor = this.computeColor(channel);
            }
        } else {
            for (AgentChannel ch : originalChannels) {
                Color c = this.computeColor(ch);
                fv.bgColor = this.mergeColor(c, fv.bgColor);
            }
        }
        cell.setFormattedValue(fv);
        return fv;
    }

    private Color computeColor(AgentChannel channel) {
        DataProviderState state = (DataProviderState)channel.get((Object)"state");
        Color color = Color.LIGHT_GRAY;
        if (state != null) {
            switch (state) {
                case ALARM: {
                    return Color.RED;
                }
                case WARNING: {
                    color = COLOR_WARNING;
                    break;
                }
                case NOMINAL: {
                    int alpha = 255;
                    try {
                        double high;
                        double low;
                        double v = this.getDouble(channel, "value");
                        try {
                            low = this.getDouble(channel, "dbandLo");
                            low = this.getDouble(channel, "limitLo") + low;
                        }
                        catch (RuntimeException x) {
                            low = this.getDouble(channel, "limitLo");
                        }
                        try {
                            high = this.getDouble(channel, "dbandHi");
                            high = this.getDouble(channel, "limitHi") - high;
                        }
                        catch (RuntimeException x) {
                            high = this.getDouble(channel, "limitHi");
                        }
                        double d = (high - low) / 4.0;
                        double a = Math.min((v - low) / d, (high - v) / d);
                        alpha = (int)(a * 255.0);
                        if (alpha >= 255) {
                            return COLOR_NOMINAL;
                        }
                        if (alpha < 70) {
                            alpha = 70;
                        }
                        return new Color(RGB_NOMINAL | alpha << 24, true);
                    }
                    catch (RuntimeException x) {
                        return COLOR_NOMINAL;
                    }
                }
                default: {
                    color = (Color)MonitorFormat.COLOR_STATE.get(state);
                }
            }
        }
        return color;
    }

    private Color mergeColor(Color c1, Color c2) {
        if (c2 == null) {
            return c1;
        }
        if (COLOR_ALARM.equals(c1) || COLOR_ALARM.equals(c2)) {
            return COLOR_ALARM;
        }
        int rgb1 = c1.getRGB() & 0xFFFFFF;
        int rgb2 = c2.getRGB() & 0xFFFFFF;
        if (rgb1 != RGB_WARNING && rgb1 != RGB_NOMINAL) {
            return c2;
        }
        if (rgb2 != RGB_WARNING && rgb2 != RGB_NOMINAL) {
            return c1;
        }
        if (rgb1 == RGB_NOMINAL) {
            if (rgb2 == RGB_NOMINAL) {
                return c1.getAlpha() < c2.getAlpha() ? c1 : c2;
            }
            return c2;
        }
        if (rgb2 == RGB_NOMINAL) {
            return c1;
        }
        return c1.getAlpha() > c2.getAlpha() ? c1 : c2;
    }

    private double getDouble(AgentChannel channel, String key) {
        Object o = channel.get((Object)key);
        if (o == null) {
            throw new RuntimeException();
        }
        if (o instanceof ConfigurationParameterInfo) {
            o = ((ConfigurationParameterInfo)o).getCurrentValue();
        }
        double value = o instanceof Double ? (Double)o : Double.parseDouble(o.toString());
        return value;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public static class Descriptor
    extends FocalPlaneView.Descriptor {
        private FocalPlaneFilter.Descriptor filter;
        private String selection;

        public FocalPlaneFilter.Descriptor getFilter() {
            return this.filter;
        }

        public void setFilter(FocalPlaneFilter.Descriptor filter) {
            this.filter = filter;
        }

        public String getSelection() {
            return this.selection;
        }

        public void setSelection(String selection) {
            this.selection = selection;
        }

        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.filter != null) {
                desc.filter = desc.filter.clone();
            }
            return desc;
        }
    }

    private static class Cell
    extends DefaultMonitorCell
    implements Updatable {
        Cell parent;
        Cell[] children;

        Cell() {
            super(new ArrayList(1), MonitorField.NULL);
        }

        void add(DisplayChannel channelHandle) {
            this.channels.add(channelHandle);
        }

        Cell getChild(int ... indices) {
            Cell cell = this;
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                if (index == -1) {
                    return cell;
                }
                if (cell.children == null) {
                    return null;
                }
                cell = cell.children[index];
                if (cell != null) continue;
                return null;
            }
            return cell;
        }

        void trim() {
            if (this.channels.isEmpty()) {
                this.channels = Collections.emptyList();
            } else {
                ((ArrayList)this.channels).trimToSize();
            }
            if (this.children != null) {
                for (Cell c : this.children) {
                    if (c == null) continue;
                    c.trim();
                }
            }
        }

        public void update(DisplayChannel channelHandle, List<MonitorField> fields) {
            this.update(channelHandle);
        }

        public void update(DisplayChannel channelHandle) {
            if (!this.channels.isEmpty()) {
                this.setFormattedValue(null);
            }
            if (this.children != null) {
                for (Cell c : this.children) {
                    if (c == null) continue;
                    c.update(channelHandle);
                }
            }
        }

        public FocalPlaneMapValue getFormattedValue() {
            return (FocalPlaneMapValue)super.getFormattedValue();
        }
    }

    private class Model
    extends AbstractFocalPlaneMapModel {
        private Cell root;

        private Model() {
        }

        @Override
        public FocalPlaneMapValue getValue() {
            return FocalPlaneMapValue.EMPTY;
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY) {
            return this.get(raftX, raftY);
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY, int reb) {
            return this.get(raftX, raftY, reb);
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY) {
            return this.get(raftX, raftY, reb, ccdY);
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY, int ampX, int ampY) {
            return this.get(raftX, raftY, reb, ccdY, ampX, ampY);
        }

        private FocalPlaneMapValue get(int ... indices) {
            if (this.root == null) {
                return null;
            }
            try {
                Cell cell = this.root.getChild(indices);
                if (cell == null) {
                    return null;
                }
                FocalPlaneMapValue fv = cell.getFormattedValue();
                return fv == null ? MapView.this.format(cell) : fv;
            }
            catch (ArrayIndexOutOfBoundsException x) {
                return null;
            }
        }

        void fireEvent() {
            this.notifyListeners(new FocalPlaneMapModelEvent(this));
        }

        void clear() {
            this.root = new Cell();
            this.root.setFormattedValue(FocalPlaneMapValue.NONE);
            MapView.this.data.values().forEach(channel -> channel.setTarget(null));
            this.fireEvent();
        }

        void rebuild() {
            this.root = new Cell();
            this.root.setFormattedValue(FocalPlaneMapValue.NONE);
            Iterator it = MapView.this.data.entrySet().iterator();
            while (it.hasNext()) {
                DisplayChannel ch = (DisplayChannel)it.next().getValue();
                String path = ch.getPath();
                int[] indices = Segment.getIndices(path);
                if (indices == null) {
                    it.remove();
                    continue;
                }
                String group = MapView.this.getGroup(path);
                if (!group.equals(MapView.this.descriptor.selection)) continue;
                Cell cell = this.addOrGetChild(indices);
                cell.add(ch);
                ch.setTarget((Updatable)cell);
            }
            this.root.trim();
            this.fireEvent();
        }

        private Cell addOrGetChild(int ... indices) {
            Cell cell = this.root;
            for (int i = 0; i < indices.length; ++i) {
                Cell child;
                int index = indices[i];
                if (index == -1) {
                    return cell;
                }
                if (cell.children == null) {
                    cell.children = new Cell[Segment.N[i]];
                }
                if ((child = cell.children[index]) == null) {
                    child = new Cell();
                    child.parent = cell;
                    cell.children[index] = child;
                }
                cell = child;
            }
            return cell;
        }
    }

    private final class Region
    extends JPanel {
        private final FocalPlaneMap map;
        private final JLabel titleLabel;
        private final JComboBox<String> comboBox;
        private boolean armed;

        Region() {
            super(new BorderLayout());
            this.armed = true;
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(Color.BLACK, 1, true)));
            this.map = new FocalPlaneMap();
            this.map.setModel(MapView.this.model);
            this.add((Component)this.map, "Center");
            Box header = Box.createHorizontalBox();
            this.add((Component)header, "North");
            this.comboBox = new JComboBox();
            header.add(this.comboBox);
            this.comboBox.addActionListener(e -> {
                if (this.armed) {
                    String s = (String)this.comboBox.getSelectedItem();
                    MapView.this.onGroupSelection(s);
                }
            });
            header.add(Box.createRigidArea(Const.HDIM));
            this.titleLabel = new JLabel(MapView.this.filter == null ? "" : MapView.this.filter.getName());
            header.add(this.titleLabel);
            header.add(Box.createHorizontalGlue());
        }

        String setGroups(List<String> groups, String selection) {
            this.armed = false;
            this.comboBox.removeAllItems();
            if (groups == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.comboBox.addItem(MapView.FILTER);
                groups.forEach(g -> this.comboBox.addItem((String)g));
                this.comboBox.setSelectedItem(selection);
            }
            this.armed = true;
            this.setTitle(MapView.this.filter.getName());
            return (String)this.comboBox.getSelectedItem();
        }

        String setSelectedGroup(String selection) {
            this.armed = false;
            this.comboBox.setSelectedItem(selection);
            this.armed = true;
            return (String)this.comboBox.getSelectedItem();
        }

        void setTitle(String title) {
            this.titleLabel.setText(title == null ? "" : title);
        }
    }
}

