/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.GroupingTemplateFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.Template;
import org.lsst.ccs.utilities.conv.TypeUtils;

public final class GroupingTemplateFilterDialog
extends JDialog {
    private GroupingTemplateFilter.Descriptor descriptor;
    private boolean other = false;
    private String[] agents;
    private ArrayList<Template> templates;
    private final JTextField nameField;
    private final JTextField agentsField;
    private final JComboBox<String> subsystemCombo;
    private final JComboBox<Segment> granularityComboIn;
    private final JList<Template> templatesIn;
    private JButton addButton;
    private JButton removeButton;
    private final JComboBox<String> groupCombo = new JComboBox();
    private final JButton upGroupButton;
    private final JButton downGroupButton;
    private final JButton addGroupButton;
    private final JButton deleteGroupButton;
    private final JButton renameGroupButton;
    private final JList<Template> templatesOut = new JList();
    private final HashMap<String, DefaultListModel<Template>> templatesOutModels = new HashMap();
    private final MonitorField[] fields = new MonitorField[]{MonitorField.AVERAGE_VALUE, MonitorField.MAX_VALUE, MonitorField.MIN_VALUE, MonitorField.MEDIAN_VALUE};
    private final JComboBox<MonitorField> fieldCombo = new JComboBox<MonitorField>(this.fields);
    private final ArrayList<Integer> selectedFields = new ArrayList();
    private final String ANY = "ANY";

    private GroupingTemplateFilterDialog(GroupingTemplateFilter.Descriptor before, Component parentComponent) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Configure filter", Dialog.ModalityType.APPLICATION_MODAL);
        this.descriptor = before == null ? new GroupingTemplateFilter.Descriptor() : before;
        List all = Console.getConsole().getStatusAggregator().getChannels(new String[]{Segment.RAFT.getKey()});
        TreeSet aa = new TreeSet();
        TreeSet tt = new TreeSet();
        all.forEach(channel -> {
            aa.add(channel.getAgentName());
            Template t = Template.valueOf(channel);
            if (t != null) {
                tt.add(t);
            }
        });
        ArrayList<String> alist = new ArrayList<String>(aa.size() + 1);
        alist.add("ANY");
        alist.addAll(aa);
        this.agents = alist.toArray(new String[0]);
        this.templates = new ArrayList(tt);
        Box rootPanel = Box.createVerticalBox();
        this.add((Component)rootPanel, "Center");
        rootPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        Box box = Box.createHorizontalBox();
        rootPanel.add(box);
        box.add(new JLabel("Name: "));
        this.nameField = new JTextField(20);
        box.add(this.nameField);
        this.nameField.setToolTipText("<html>Filter name will be used for panel titles<br> unless otherwise specified.");
        box.add(Box.createHorizontalGlue());
        rootPanel.add(Box.createRigidArea(Const.VDIM));
        box = Box.createHorizontalBox();
        rootPanel.add(box);
        box.add(new JLabel("Subsystems: "));
        this.agentsField = new JTextField(20);
        box.add(this.agentsField);
        this.agentsField.setToolTipText("<html>Subsystems to be considered when templates<br> do not explicitly specify a subsystem name.");
        this.agentsField.addActionListener(e -> this.updateAvailable());
        this.agentsField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                GroupingTemplateFilterDialog.this.updateAvailable();
            }
        });
        box.add(Box.createHorizontalGlue());
        rootPanel.add(Box.createRigidArea(Const.VDIM));
        Box availablePanel = Box.createVerticalBox();
        rootPanel.add(availablePanel);
        availablePanel.setBorder(BorderFactory.createTitledBorder("Available templates"));
        box = Box.createHorizontalBox();
        availablePanel.add(box);
        box.add(new JLabel("Subsystem: "));
        this.subsystemCombo = new JComboBox<String>(this.agents);
        box.add(this.subsystemCombo);
        this.subsystemCombo.addActionListener(e -> this.updateAvailable());
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(new JLabel("Granularity: "));
        this.granularityComboIn = new JComboBox<Segment>(Segment.values());
        box.add(this.granularityComboIn);
        this.granularityComboIn.addActionListener(e -> this.updateAvailable());
        box.add(Box.createHorizontalGlue());
        availablePanel.add(Box.createRigidArea(Const.VDIM));
        this.templatesIn = new JList();
        availablePanel.add(new JScrollPane(this.templatesIn));
        this.templatesIn.setSelectionMode(0);
        this.templatesIn.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, ((Template)value).code, index, isSelected, cellHasFocus);
            }
        });
        this.templatesIn.addListSelectionListener(e -> this.addButton.setEnabled(this.templatesIn.getSelectedValue() != null && this.groupCombo.getSelectedItem() != null));
        rootPanel.add(Box.createRigidArea(Const.VDIM));
        box = Box.createHorizontalBox();
        rootPanel.add(box);
        box.add(Box.createRigidArea(Const.HDIM));
        this.addButton = new JButton("  Add  ");
        this.addButton.setToolTipText("Add selected template to selected display path");
        box.add(this.addButton);
        this.addButton.addActionListener(e -> {
            Template template = this.templatesIn.getSelectedValue();
            if (template != null) {
                DefaultListModel out = (DefaultListModel)this.templatesOut.getModel();
                out.addElement(template);
                DefaultListModel in = (DefaultListModel)this.templatesIn.getModel();
                in.removeElement(template);
            }
        });
        this.addButton.setEnabled(false);
        box.add(Box.createRigidArea(Const.HDIM));
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Remove selected template from selected display path");
        box.add(this.removeButton);
        this.removeButton.addActionListener(e -> {
            Template template = this.templatesOut.getSelectedValue();
            if (template != null) {
                DefaultListModel out = (DefaultListModel)this.templatesOut.getModel();
                out.removeElement(template);
                this.updateAvailable();
            }
        });
        this.removeButton.setEnabled(false);
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(Box.createHorizontalGlue());
        rootPanel.add(Box.createRigidArea(Const.VDIM));
        Box selectedPanel = Box.createVerticalBox();
        rootPanel.add(selectedPanel);
        selectedPanel.setBorder(BorderFactory.createTitledBorder("Display channels"));
        box = Box.createHorizontalBox();
        selectedPanel.add(box);
        JLabel label = new JLabel("Channel: ");
        box.add(label);
        label.setToolTipText("<html>Display channel names.<br>Used as column names in summary tables.");
        box.add(this.groupCombo);
        this.groupCombo.setPrototypeDisplayValue("12345678901234567890");
        this.groupCombo.addActionListener(e -> this.updateSelected());
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(Box.createHorizontalGlue());
        this.upGroupButton = new JButton(" Up ");
        box.add(this.upGroupButton);
        this.upGroupButton.setToolTipText("Move selected channel up in the list.");
        this.upGroupButton.addActionListener(e -> {
            int i = this.groupCombo.getSelectedIndex();
            if (i > 0) {
                Integer field = this.selectedFields.get(i);
                this.selectedFields.set(i, this.selectedFields.get(i - 1));
                this.selectedFields.set(i - 1, field);
                String s = this.groupCombo.getItemAt(i);
                this.groupCombo.removeItemAt(i);
                this.groupCombo.insertItemAt(s, i - 1);
                this.groupCombo.setSelectedIndex(i - 1);
            }
        });
        this.downGroupButton = new JButton("Down");
        box.add(this.downGroupButton);
        this.downGroupButton.setToolTipText("Move selected channel down in the list.");
        this.downGroupButton.addActionListener(e -> {
            int i = this.groupCombo.getSelectedIndex();
            if (i != -1 && i < this.groupCombo.getItemCount() - 1) {
                Integer field = this.selectedFields.get(i);
                this.selectedFields.set(i, this.selectedFields.get(i + 1));
                this.selectedFields.set(i + 1, field);
                String s = this.groupCombo.getItemAt(i);
                this.groupCombo.removeItemAt(i);
                this.groupCombo.insertItemAt(s, i + 1);
                this.groupCombo.setSelectedIndex(i + 1);
            }
        });
        this.addGroupButton = new JButton("New...");
        box.add(this.addGroupButton);
        this.addGroupButton.setToolTipText("Add a new channel after the selected one.");
        this.addGroupButton.addActionListener(e -> {
            String s = JOptionPane.showInputDialog(this.addGroupButton, (Object)"Enter channel name");
            if (s != null) {
                this.templatesOutModels.put(s, new DefaultListModel());
                int i = this.groupCombo.getSelectedIndex() + 1;
                this.selectedFields.add(i, 0);
                this.groupCombo.insertItemAt(s, i);
                this.groupCombo.setSelectedIndex(i);
            }
        });
        this.deleteGroupButton = new JButton("Delete");
        box.add(this.deleteGroupButton);
        this.deleteGroupButton.setToolTipText("Delete selected channel.");
        this.deleteGroupButton.addActionListener(e -> {
            int i = this.groupCombo.getSelectedIndex();
            if (i != -1) {
                this.groupCombo.removeItemAt(i);
                this.selectedFields.remove(i);
            }
        });
        this.renameGroupButton = new JButton("Rename");
        box.add(this.renameGroupButton);
        this.renameGroupButton.setToolTipText("Rename selected channel.");
        this.renameGroupButton.addActionListener(e -> {
            String s;
            String old = (String)this.groupCombo.getSelectedItem();
            if (old != null && (s = JOptionPane.showInputDialog(this.renameGroupButton, "Enter channel name", old)) != null && !s.equals(old)) {
                DefaultListModel<Template> model = this.templatesOutModels.remove(old);
                this.templatesOutModels.put(s, model);
                int i = this.groupCombo.getSelectedIndex();
                this.groupCombo.removeItemAt(i);
                this.groupCombo.insertItemAt(s, i);
                this.groupCombo.setSelectedIndex(i);
            }
        });
        box.add(this.fieldCombo);
        this.fieldCombo.setToolTipText("What to display for this channel");
        this.fieldCombo.addActionListener(e -> {
            int i = this.groupCombo.getSelectedIndex();
            if (i != -1) {
                this.selectedFields.set(i, this.fieldCombo.getSelectedIndex());
            }
        });
        box.add(Box.createRigidArea(Const.HDIM));
        selectedPanel.add(Box.createRigidArea(Const.VDIM));
        selectedPanel.add(new JScrollPane(this.templatesOut));
        this.templatesOut.setSelectionMode(0);
        this.templatesOut.addListSelectionListener(e -> this.removeButton.setEnabled(this.templatesOut.getSelectedValue() != null));
        box = Box.createHorizontalBox();
        this.add((Component)box, "South");
        box.add(Box.createRigidArea(Const.HDIM));
        JButton saveButton = new JButton("Save...");
        box.add(saveButton);
        saveButton.setToolTipText("Save this filter for future use");
        saveButton.addActionListener(e -> {
            this.writeDescriptor();
            ((PersistenceService)Console.getConsole().getSingleton(PersistenceService.class)).saveAs((Persistable.Descriptor)this.descriptor, "Saving...", (Component)this);
        });
        box.add(Box.createRigidArea(Const.HDIM));
        JButton otherButton = new JButton("Other...");
        box.add(otherButton);
        otherButton.setToolTipText("Create a different type of filter");
        otherButton.addActionListener(e -> {
            this.other = true;
            this.dispose();
        });
        box.add(Box.createRigidArea(Const.HDIM));
        box.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        box.add(cancelButton);
        cancelButton.addActionListener(e -> {
            this.descriptor = null;
            this.dispose();
        });
        box.add(Box.createRigidArea(Const.HDIM));
        JButton okButton = new JButton(" OK ");
        box.add(okButton);
        okButton.addActionListener(e -> {
            this.writeDescriptor();
            this.dispose();
        });
        box.add(Box.createRigidArea(Const.HDIM));
        this.readDescriptor();
    }

    public static GroupingTemplateFilter edit(GroupingTemplateFilter before, Component parentComponent) {
        if (parentComponent == null) {
            parentComponent = Console.getConsole().getWindow();
        }
        GroupingTemplateFilterDialog dialog = new GroupingTemplateFilterDialog(before == null ? null : before.save(), parentComponent);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        if (dialog.other) {
            return null;
        }
        if (dialog.descriptor == null) {
            throw new CancellationException();
        }
        return new GroupingTemplateFilter(dialog.descriptor);
    }

    private void updateAvailable() {
        String agent = (String)this.subsystemCombo.getSelectedItem();
        Segment segment = (Segment)((Object)this.granularityComboIn.getSelectedItem());
        DefaultListModel<Template> inModel = new DefaultListModel<Template>();
        DefaultListModel outModel = (DefaultListModel)this.templatesOut.getModel();
        if (agent.equals("ANY")) {
            ArrayList<String> selectedAgents = this.getSelectedAgents();
            for (Template template : this.templates) {
                if (!template.segment.equals((Object)segment) || selectedAgents != null && !selectedAgents.contains(template.getAgent()) || outModel.contains(template = template.stripAgent())) continue;
                inModel.addElement(template);
            }
        } else {
            for (Template template : this.templates) {
                if (!template.segment.equals((Object)segment) || !template.getAgent().equals(agent) || outModel.contains(template)) continue;
                inModel.addElement(template);
            }
        }
        this.templatesIn.setModel(inModel);
    }

    private void updateSelected() {
        String group = (String)this.groupCombo.getSelectedItem();
        DefaultListModel<Template> model = this.templatesOutModels.get(group);
        this.templatesOut.setModel(model);
        int i = this.groupCombo.getSelectedIndex();
        this.upGroupButton.setEnabled(i > 0);
        this.downGroupButton.setEnabled(i != -1 && i < this.groupCombo.getItemCount() - 1);
        this.deleteGroupButton.setEnabled(i != -1);
        this.renameGroupButton.setEnabled(i != -1);
        if (i != -1) {
            this.fieldCombo.setSelectedIndex(this.selectedFields.get(i));
        }
        this.updateAvailable();
    }

    private void readDescriptor() {
        String name = this.descriptor.getName();
        if (name == null) {
            this.nameField.setText("");
        } else {
            this.nameField.setText(name);
        }
        String[] aa = this.descriptor.getAgents();
        if (aa == null) {
            this.agentsField.setText("");
        } else {
            this.agentsField.setText(TypeUtils.stringify((Object)aa));
        }
        LinkedHashMap<String, ArrayList<String>> groups = this.descriptor.getGroups();
        this.templatesOutModels.clear();
        this.templatesOutModels.put(null, new DefaultListModel());
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
        if (groups != null && !groups.isEmpty()) {
            groups.forEach((group, templates) -> {
                comboModel.addElement(group);
                DefaultListModel model = new DefaultListModel();
                if (templates != null) {
                    templates.forEach(t -> model.addElement(Template.fromString(t)));
                }
                this.templatesOutModels.put((String)group, model);
            });
            String[] ff = this.descriptor.getFields();
            if (ff == null || ff.length != groups.size()) {
                int i = groups.size();
                while (--i >= 0) {
                    this.selectedFields.add(0);
                }
            } else {
                for (String f : ff) {
                    int i = this.fields.length;
                    while (--i >= 0) {
                        MonitorField mf = this.fields[i];
                        if (!mf.getTitle().equals(f)) continue;
                        this.selectedFields.add(i);
                        break;
                    }
                    if (i >= 0) continue;
                    this.selectedFields.add(0);
                }
            }
        }
        this.groupCombo.setModel(comboModel);
        this.updateSelected();
    }

    private void writeDescriptor() {
        String name = this.nameField.getText();
        if (name.trim().isEmpty()) {
            this.descriptor.setName(null);
        } else {
            this.descriptor.setName(name);
        }
        ArrayList<String> aa = this.getSelectedAgents();
        if (aa == null) {
            this.descriptor.setAgents(null);
        } else {
            this.descriptor.setAgents(aa.toArray(new String[0]));
        }
        int nGroups = this.groupCombo.getItemCount();
        if (nGroups == 0) {
            this.descriptor.setGroups(null);
            this.descriptor.setFields(null);
        } else {
            Object group;
            LinkedHashMap<String, ArrayList<String>> groups = new LinkedHashMap<String, ArrayList<String>>();
            for (int i = 0; i < nGroups; ++i) {
                group = this.groupCombo.getItemAt(i);
                DefaultListModel<Template> model = this.templatesOutModels.get(group);
                if (model == null) continue;
                ArrayList<String> templates = new ArrayList<String>(model.getSize());
                Enumeration<Template> en = model.elements();
                while (en.hasMoreElements()) {
                    templates.add(en.nextElement().toString());
                }
                groups.put((String)group, templates);
            }
            this.descriptor.setGroups(groups);
            boolean saveFields = false;
            group = this.selectedFields.iterator();
            while (group.hasNext()) {
                int f = (Integer)group.next();
                if (f == 0) continue;
                saveFields = true;
                break;
            }
            if (saveFields) {
                String[] ff = new String[this.selectedFields.size()];
                int i = ff.length;
                while (--i >= 0) {
                    ff[i] = this.fields[this.selectedFields.get(i)].getTitle();
                }
                this.descriptor.setFields(ff);
            } else {
                this.descriptor.setFields(null);
            }
        }
    }

    private ArrayList<String> getSelectedAgents() {
        String text = this.agentsField.getText().trim();
        if (text.isEmpty() || text.equals("_null_")) {
            return null;
        }
        if (text.startsWith("[") && text.endsWith("]")) {
            text = text.substring(1, text.length() - 1);
        }
        String[] ss = text.split("[ ,]+");
        ArrayList<String> out = new ArrayList<String>(ss.length);
        for (String s : ss) {
            out.add(s.trim());
        }
        return out;
    }
}

