/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.GroupingTemplateFilterDialog;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.Template;

public class GroupingTemplateFilter
extends FocalPlaneFilter {
    public static final String PATH = "Built-In/Template";
    private final Descriptor descriptor;
    private final HashMap<Template, ArrayList<String>> template2groups = new HashMap();

    private GroupingTemplateFilter() {
        this.descriptor = new Descriptor();
        this.descriptor.setGroups(new LinkedHashMap<String, ArrayList<String>>(0));
    }

    public GroupingTemplateFilter(Descriptor desc) {
        this.descriptor = desc.clone();
        if (this.descriptor.getGroups() != null) {
            for (Map.Entry<String, ArrayList<String>> e : this.descriptor.getGroups().entrySet()) {
                for (String st : e.getValue()) {
                    try {
                        Template t = Template.fromString(st);
                        ArrayList<String> groups = this.template2groups.get(t);
                        if (groups == null) {
                            groups = new ArrayList(1);
                            this.template2groups.put(t, groups);
                        }
                        groups.add(e.getKey());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
    }

    @Create(category="FocalPlaneFilter", name="Template Groups", path="Built-In/Template", description="Channels filter that maps groups of focal plane channels to display paths based on path templates.")
    public static GroupingTemplateFilter create() {
        GroupingTemplateFilter f = new GroupingTemplateFilter();
        Creator.Descriptor cd = new Creator.Descriptor();
        cd.setCategory("FocalPlaneFilter");
        cd.setPath(PATH);
        f.getDescriptor().setCreator(cd);
        f = f.edit(null, null);
        if (f == null) {
            throw new CancellationException();
        }
        return f;
    }

    public String getName() {
        return this.getDescriptor().getName();
    }

    @Override
    public List<String> getAgents() {
        boolean hasAgentless = false;
        LinkedHashSet<String> aa = new LinkedHashSet<String>();
        for (ArrayList<String> tt : this.getDescriptor().getGroups().values()) {
            for (String t : tt) {
                String agent = Template.getAgent(t);
                if (agent.isEmpty()) {
                    hasAgentless = true;
                    continue;
                }
                aa.add(agent);
            }
        }
        if (hasAgentless) {
            String[] agents = this.getDescriptor().getAgents();
            if (agents == null) {
                return null;
            }
            ArrayList<String> out = new ArrayList<String>(aa);
            out.addAll(Arrays.asList(agents));
            return out;
        }
        return new ArrayList<String>(aa);
    }

    @Override
    public List<String> getOriginPaths(String displayPath) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        return this.getDisplayPaths(channel.getPath());
    }

    public List<String> getDisplayPaths(String originPath) {
        String[] agents;
        int[] indices = Segment.getIndices(originPath);
        if (indices == null) {
            return Collections.emptyList();
        }
        Template template = Template.valueOf(originPath, indices);
        if (template == null) {
            return Collections.emptyList();
        }
        ArrayList<String> groups = this.template2groups.get(template);
        if (groups == null && ((agents = this.getDescriptor().getAgents()) == null || Arrays.asList(agents).contains(originPath.substring(0, originPath.indexOf("/"))))) {
            template = template.stripAgent();
            groups = this.template2groups.get(template);
        }
        if (groups == null) {
            return Collections.emptyList();
        }
        String prefix = Segment.getPathPrefix(indices);
        return groups.stream().map(s -> prefix + s).collect(Collectors.toList());
    }

    public List<String> getFields(boolean compact) {
        LinkedHashMap<String, ArrayList<String>> groups = this.descriptor.getGroups();
        if (compact) {
            String[] ff = this.descriptor.getFields();
            int n = groups.size();
            if (ff == null || ff.length != n) {
                ArrayList<String> out = new ArrayList<String>(n);
                String field = "AVERAGE_VALUE";
                for (int i = 0; i < n; ++i) {
                    out.add(field);
                }
                return out;
            }
            return new ArrayList<String>(Arrays.asList(ff));
        }
        return null;
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        return this.getDescriptor().clone();
    }

    public GroupingTemplateFilter edit(String title, Component parent) {
        return GroupingTemplateFilterDialog.edit(this, parent);
    }

    public static class Descriptor
    extends FocalPlaneFilter.Descriptor {
        private LinkedHashMap<String, ArrayList<String>> groups;
        private String[] agents;
        private String[] fields;

        public LinkedHashMap<String, ArrayList<String>> getGroups() {
            return this.groups;
        }

        public void setGroups(LinkedHashMap<String, ArrayList<String>> groups) {
            this.groups = groups;
        }

        public String[] getAgents() {
            return this.agents;
        }

        public void setAgents(String[] agents) {
            this.agents = agents;
        }

        public String[] getFields() {
            return this.fields;
        }

        public void setFields(String[] fields) {
            this.fields = fields;
        }

        @Override
        public Descriptor clone() {
            Descriptor clone = (Descriptor)super.clone();
            if (this.groups == null) {
                this.groups = new LinkedHashMap(0);
            } else {
                for (Map.Entry<String, ArrayList<String>> e : this.groups.entrySet()) {
                    e.setValue((ArrayList)e.getValue().clone());
                }
            }
            return clone;
        }
    }
}

