/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public interface GroupView
extends MonitorView {
    public static final MonitorField DEFAULT_FIELD = MonitorField.AVERAGE_VALUE;
    public static final MonitorField[] AVAILABLE_FIELDS = new MonitorField[]{MonitorField.AVERAGE_VALUE, MonitorField.MAX_VALUE, MonitorField.MIN_VALUE, MonitorField.MEDIAN_VALUE};

    default public String getGroup(String displayPath) {
        int i = displayPath.lastIndexOf("/");
        return displayPath.substring(i + 1);
    }

    default public List<String> getGroups() {
        List<String> channels = this.getFilter().getDisplayChannels();
        if (channels == null) {
            return null;
        }
        LinkedHashSet groups = new LinkedHashSet();
        channels.forEach(displayPath -> {
            String group = this.getGroup((String)displayPath);
            if (group != null) {
                groups.add(group);
            }
        });
        return new ArrayList<String>(groups);
    }

    default public List<MonitorField> getFields() {
        AgentChannelsFilter filter = this.getFilter();
        if (filter == null) {
            return null;
        }
        List<String> channels = filter.getDisplayChannels();
        if (channels == null) {
            return null;
        }
        List<String> fields = filter.getFields(true);
        if (fields == null || fields.size() != channels.size()) {
            return null;
        }
        return fields.stream().map(s -> this.stringToField((String)s)).collect(Collectors.toList());
    }

    default public MonitorField stringToField(String field) {
        for (MonitorField mf : AVAILABLE_FIELDS) {
            if (!mf.toString().equals(field)) continue;
            return mf;
        }
        return DEFAULT_FIELD;
    }

    default public String fieldToString(MonitorField field) {
        return field.toString();
    }
}

