package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;

/**
 * 
 *
 * @author The LSST CCS Team
 */
public class RebPowerStateFormatter extends MonitorFormat {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------

    static private Pattern powerStates = Pattern.compile("([^/]+)/state/(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/Reb(?<stateId>(Power|HvBias|DPhi))State");


    static public String[] getPowerStates(String path) {
        Matcher m = powerStates.matcher(path);
        if (m.matches()) {
            return new String[] {m.group(1), m.group("raftId") + "/"+m.group("rebId"), m.group("stateId")};
        } else {
            return null;
        }
    }

    @Override
    public FormattedValue format(FormattedValue fv) {
//        if (fv.value instanceof PduOutletState) {
        if ("ON".equals(fv.value) || "OFF".equals(fv.value)) {
            if (fv.bgColor == null) fv.bgColor = fv.value.equals("ON") ? COLOR_GOOD : COLOR_WARN;
            if (fv.toolTip == null) fv.toolTip = "Click to switch ON/OFF";
            fv.click1 = cell -> {
                if (cell != null) {
                    List<DisplayChannel> hh = cell.getChannels();
                    if (hh.size() == 1) {
                        AgentChannel channel = hh.get(0).getChannel();
                        if (channel != null) {
                            String[] ss = getPowerStates(channel.getPath());
                            if (ss != null) {
                                
                                String agent = ss[0];
                                String power = ss[2].equals("HvBias") ? "hvBias" : ss[2].equals("Power") ? "powerReb" : "dphi";                                
                                String reb = ss[1];
                                String target = agent+"/"+reb;
                                
                                String status = channel.get().toString();
                                boolean on = "ON".equals(status);
                                status = on ? "OFF" : "ON";                                
                                String command = power+= status.substring(0,1).toUpperCase() + status.substring(1).toLowerCase();

                                int flip = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Switch the "+power+" for reb "+reb+"<br><b>"+ status +"</b> ?", "Switch "+reb +" " + status, JOptionPane.OK_CANCEL_OPTION);
                                if (flip == JOptionPane.OK_OPTION) {
                                    Console.getConsole().sendCommand(target + "/"+command);
                                }
                            }
                        }
                    }
                }
            };
        }
        return super.format(fv);
    }
    
}
