/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;

@Plugin(name="LSST Alert Notification Plugin", id="alert", description="LSST CCS alert notification service.")
public class LsstAlertPlugin
extends ConsolePlugin {
    private static final String OPT_AUTO_START_VIEWER = "autoStartViewer";
    private static final String OPT_AUTO_START_TRACER = "autoStartTracer";
    static final String OPT_HISTORY = "history";
    static final String OPT_MUTE = "mute";
    static final String OPT_TOFRONT = "toFront";
    static final String OPT_SELECT = "selectLast";
    private AlertService alertService;
    private Action viewerAction;
    private volatile AlertViewer viewer;

    @Override
    public void initialize() {
        this.alertService = (AlertService)this.getConsole().getAgentService(AlertService.class);
        this.getServices().addProperty(OPT_AUTO_START_VIEWER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, "Startup", "${autoStartViewer} Start viewer on console sturtup.");
        this.getServices().addProperty(OPT_AUTO_START_TRACER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, "Startup", "${autoStartTracer} Start message viewer on console sturtup.");
        this.getServices().addProperty(OPT_HISTORY, false);
        this.getServices().addProperty(OPT_MUTE, false);
        this.getServices().addProperty(OPT_TOFRONT, true);
        this.getServices().addProperty(OPT_SELECT, true);
        this.viewerAction = new AbstractAction("Viewer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    LsstAlertPlugin.this.onNewAlertViewer(null);
                } else {
                    LsstAlertPlugin.this.stopAlertViewer();
                }
            }
        };
        this.viewerAction.putValue("SwingSelectedKey", false);
        this.getServices().addMenu(this.viewerAction, "400: CCS Tools :-1:4", "Alerts:1");
        AbstractAction act = new AbstractAction("Messages"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstAlertPlugin.this.onNewAlertTracer();
            }
        };
        this.getServices().addMenu(act, "400: CCS Tools :-1:4", "Alerts:2");
    }

    @Override
    public void start() {
        if (((Boolean)this.getServices().getProperty(OPT_AUTO_START_VIEWER)).booleanValue()) {
            this.onNewAlertViewer(null);
        }
        if (((Boolean)this.getServices().getProperty(OPT_AUTO_START_TRACER)).booleanValue()) {
            this.onNewAlertTracer();
        }
    }

    @Override
    public void shutdown() {
    }

    public void onNewAlertViewer(AlertViewer.Descriptor config) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.viewer == null) {
                this.viewerAction.putValue("SwingSelectedKey", true);
                this.viewer = new AlertViewer(this, config);
                this.alertService.addListener((AlertListener)this.viewer);
            }
        } else {
            SwingUtilities.invokeLater(() -> this.onNewAlertViewer(config));
        }
    }

    public void stopAlertViewer() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.viewer != null) {
                this.viewerAction.putValue("SwingSelectedKey", false);
                this.alertService.removeListener((AlertListener)this.viewer);
                this.viewer.stop();
                this.viewer = null;
            }
        } else {
            SwingUtilities.invokeLater(this::stopAlertViewer);
        }
    }

    public void onNewAlertTracer() {
        LsstTracerPlugin tracerPlugin = (LsstTracerPlugin)this.getConsole().getConsoleLookup().lookup(LsstTracerPlugin.class);
        Tracer tracer = tracerPlugin.createTracer("Alerts", "BuiltIn/Alerts");
        tracer.setFilter(filteredMessage -> {
            BusMessage bm = filteredMessage.getBusMessage();
            if (bm instanceof StatusRaisedAlert) {
                StatusRaisedAlert am = (StatusRaisedAlert)bm;
                Alert alert = am.getRaisedAlert();
                String id = alert.getAlertId();
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getCCSTimeStamp().getUTCInstant())).append(" : ");
                sb.append(am.getRaisedAlertState());
                sb.append(" from ").append(am.getOriginAgentInfo().getName()).append(".\n");
                sb.append("ID: ").append(id).append(".  Description:\n");
                sb.append(alert.getDescription()).append("\n");
                filteredMessage.setMessage(sb.toString());
                return filteredMessage;
            }
            if (bm instanceof StatusClearedAlert) {
                StatusClearedAlert am = (StatusClearedAlert)bm;
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getCCSTimeStamp().getUTCInstant())).append(" : ");
                sb.append(am.getOriginAgentInfo().getName()).append(" cleared alerts ");
                for (String id : am.getClearAlertIds()) {
                    sb.append(id).append(", ");
                }
                sb.delete(sb.length() - 2, sb.length()).append(".\n");
                filteredMessage.setMessage(sb.toString());
                return filteredMessage;
            }
            return null;
        });
    }

    public void clearAlerts(Map<String, String[]> alarms) {
        AgentMessagingLayer messenger = this.getConsole().getMessagingAccess();
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processResult(CommandResult result) {
            }

            public void processNack(CommandNack nack) {
            }
        };
        alarms.forEach((source, ids) -> {
            if (this.getConsole().getMessagingAccess().getAgentPresenceManager().agentExists(source)) {
                CommandRequest request = ids == null ? new CommandRequest(source, "clearAllAlerts") : new CommandRequest(source, "clearAlerts", new Object[]{ids});
                messenger.sendCommandRequest(request, originator);
            } else if (ids == null) {
                this.alertService.clearAllAlertsForSource(source);
            } else {
                this.alertService.clearAlertsForSource(source, ids);
            }
        });
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        desc.setHistory((Boolean)this.getServices().getProperty(OPT_HISTORY));
        desc.setMute((Boolean)this.getServices().getProperty(OPT_MUTE));
        desc.setToFront((Boolean)this.getServices().getProperty(OPT_TOFRONT));
        desc.setSelectLast((Boolean)this.getServices().getProperty(OPT_SELECT));
        if (this.viewer != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                desc.setViewerConfig(this.viewer.save());
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        if (this.viewer != null) {
                            desc.setViewerConfig(this.viewer.save());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        if (!(storageBean instanceof Descriptor)) {
            throw new IllegalArgumentException("Illegal descriptor type: " + storageBean.getClassName());
        }
        Descriptor desc = (Descriptor)storageBean;
        this.getServices().setProperty(OPT_HISTORY, desc.isHistory());
        this.getServices().setProperty(OPT_MUTE, desc.isMute());
        this.getServices().setProperty(OPT_TOFRONT, desc.isToFront());
        this.getServices().setProperty(OPT_SELECT, desc.isSelectLast());
        AlertViewer.Descriptor viewerConfig = desc.getViewerConfig();
        if (viewerConfig == null) {
            if (this.viewer != null) {
                this.stopAlertViewer();
            }
        } else {
            this.stopAlertViewer();
            this.onNewAlertViewer(viewerConfig);
        }
        return true;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private boolean selectLast;
        private boolean toFront;
        private boolean mute;
        private boolean history;
        private AlertViewer.Descriptor viewerConfig;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public boolean isSelectLast() {
            return this.selectLast;
        }

        public void setSelectLast(boolean selectLast) {
            this.selectLast = selectLast;
        }

        public boolean isToFront() {
            return this.toFront;
        }

        public void setToFront(boolean toFront) {
            this.toFront = toFront;
        }

        public boolean isMute() {
            return this.mute;
        }

        public void setMute(boolean mute) {
            this.mute = mute;
        }

        public boolean isHistory() {
            return this.history;
        }

        public void setHistory(boolean history) {
            this.history = history;
        }

        public AlertViewer.Descriptor getViewerConfig() {
            return this.viewerConfig;
        }

        public void setViewerConfig(AlertViewer.Descriptor viewerConfig) {
            this.viewerConfig = viewerConfig;
        }
    }
}

