/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.config.CategoryTag;

public class ConfigurationDescription
implements Serializable {
    private static final long serialVersionUID = 2262886830605244842L;
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "defaultInitial";
    public static final String DEFAULT_CAT = "";
    public static final String SAFE_CONFIG_NAME = "safe";
    private String name = null;
    private int version = -3;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, String> categoryTags = new HashMap<String, String>();
    private final Map<String, Integer> categoryVersions = new HashMap<String, Integer>();
    private final Map<String, CategoryTag> categoryTagsMap = new TreeMap<String, CategoryTag>();

    public ConfigurationDescription() {
    }

    public ConfigurationDescription(Set<String> categories) {
        this.categories.addAll(categories);
    }

    public static ConfigurationDescription safeConfiguration(Set<String> categories) {
        ConfigurationDescription res = new ConfigurationDescription(categories);
        for (String cat : categories) {
            res.putTagForCategory(cat, SAFE_CONFIG_NAME, null);
        }
        return res;
    }

    public ConfigurationDescription parseConfigurationString(String ... taggedCategories) {
        return this.parseConfigurationString(false, taggedCategories);
    }

    public ConfigurationDescription parseConfigurationString(boolean newMeaningOfDefault, String ... taggedCategories) {
        if (taggedCategories == null || taggedCategories.length == 0) {
            return this;
        }
        for (String s : taggedCategories) {
            CategoryTag categoryTag = CategoryTag.parseCategoryTagInput(s, newMeaningOfDefault);
            this.addCategoryTag(categoryTag);
        }
        return this;
    }

    public void removeCategory(String cat) {
        this.categories.remove(cat);
        CategoryTag catTag = this.categoryTagsMap.remove(cat);
        if (catTag != null) {
            for (String tag : catTag.getTags()) {
                this.categoryTags.remove(cat);
                this.categoryVersions.remove(cat);
            }
        }
    }

    public ConfigurationDescription withDefaults(boolean withDefaults) {
        if (withDefaults) {
            for (String cat : this.categories) {
                if (this.categoryTagsMap.containsKey(cat)) continue;
                this.putTagForCategory(cat, "", -1);
            }
        }
        return this;
    }

    public ConfigurationDescription withDefaultInitial(boolean withDefaults) {
        if (withDefaults) {
            for (String cat : this.categories) {
                if (this.categoryTagsMap.containsKey(cat)) continue;
                this.putTagForCategory(cat, DEFAULT_INITIAL_CONFIG_NAME, -1);
            }
        }
        return this;
    }

    public void addCategoryTag(CategoryTag categoryTag) {
        String cat = categoryTag.getCategoryName();
        CategoryTag newCat = new CategoryTag(categoryTag.getCategoryName()).merge(categoryTag);
        newCat.setHasChanges(categoryTag.hasChanges);
        this.categoryTagsMap.put(cat, newCat);
        for (String tag : categoryTag.getTags()) {
            this.categoryTags.put(cat, tag);
            this.categoryVersions.put(cat, categoryTag.getTagVersion(tag));
        }
    }

    public void putTagForCategory(String cat, String tag, Integer version) {
        CategoryTag catTag = this.categoryTagsMap.get(cat);
        if (catTag == null) {
            catTag = new CategoryTag(cat);
            this.categoryTagsMap.put(cat, catTag);
        }
        catTag.addOrUpdateTagVersion(tag, version);
        this.categoryTags.put(cat, tag);
        this.categoryVersions.put(cat, version);
    }

    public Set<String> getCategoriesSet() {
        return Collections.unmodifiableSet(this.categoryTagsMap.keySet());
    }

    public CategoryTag getCategoryTag(String category) {
        return this.categoryTagsMap.get(category);
    }

    @Deprecated
    public Map<String, String> getCategoryTags() {
        return Collections.unmodifiableMap(this.categoryTags);
    }

    @Deprecated
    public Map<String, Integer> getCategoryVersions() {
        return Collections.unmodifiableMap(this.categoryVersions);
    }

    public boolean isEmpty() {
        return this.categoryTagsMap.isEmpty();
    }

    public boolean containsCategory(String category) {
        return this.categoryTagsMap.containsKey(category);
    }

    public String getDescriptionName() {
        return "[" + this.toString() + "]";
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public void setName(String name, int version) {
        this.name = name;
        this.version = version;
    }

    public ConfigurationDescription merge(ConfigurationDescription input) {
        for (String category : input.getCategoriesSet()) {
            CategoryTag inputCategoryTag = input.getCategoryTag(category);
            CategoryTag thisCategoryTag = this.getCategoryTag(category);
            if (thisCategoryTag == null) {
                this.categories.add(category);
                this.addCategoryTag(inputCategoryTag);
                continue;
            }
            for (String tag : inputCategoryTag.getTags()) {
                thisCategoryTag.addOrUpdateTagVersion(tag, inputCategoryTag.getTagVersion(tag));
            }
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.categoryTagsMap);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationDescription other = (ConfigurationDescription)obj;
        return this.categoryTagsMap.equals(other.categoryTagsMap);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(0);
        for (Map.Entry<String, CategoryTag> e : this.categoryTagsMap.entrySet()) {
            CategoryTag catTag = e.getValue();
            sb.append(catTag.toString());
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static ConfigurationDescription fromConfigurationInfo(ConfigurationInfo ci, Set<String> categories) {
        String desc = ci.getConfigurationDescription();
        desc = desc.replace("[", "").replace("]", "");
        ConfigurationDescription cd = new ConfigurationDescription();
        cd = cd.parseConfigurationString(desc.split(","));
        ConfigurationDescription res = new ConfigurationDescription();
        for (String cat : cd.getCategoriesSet()) {
            if (!categories.contains(cat)) continue;
            res.addCategoryTag(cd.getCategoryTag(cat));
        }
        return res;
    }

    public static ConfigurationDescription fromConfigurationInfo(ConfigurationInfo ci) {
        return ConfigurationDescription.fromConfigurationInfo(ci, ci.getCategorySet());
    }
}

