/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;

public class ATSPowerControlPanel
extends JPanel {
    private static final Map<Integer, String> chanNames = new HashMap<Integer, String>();
    private static final String SOLID_BAR = "\u2588\u2588\u2588\u2588";
    private final CommandSender sender;
    private SystemStatusPanel sysStatusPnl;
    private JButton btnPowerOn;
    private JButton btnPowerOff;
    private JButton btnDphiOn;
    private JButton btnDphiOff;
    private JTextField tfDphiVal = new JTextField();
    private JButton btnBiasOn;
    private JButton btnBiasOff;
    private JTextField tfBiasVal = new JTextField();
    private final JLabel[] lblChanStatus = new JLabel[7];
    private JButton btnOtmOn;
    private JButton btnOtmOff;
    private JButton btnFanOn;
    private JButton btnFanOff;
    private JButton btnAuxOn;
    private JButton btnAuxOff;
    private JLabel lblOtmStatus;
    private JLabel lblFanStatus;
    private JLabel lblAuxStatus;
    private double hvBias;
    private double dphi;
    private static final long serialVersionUID = 1L;

    public ATSPowerControlPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new UpdatePowerStatus(new ATSPowerState(0, new Boolean[10], 0.0, 0.0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.btnPowerOn = this.newButton("On", UiConstants.GREEN, "powerOn");
        this.btnPowerOff = this.newButton("Off", UiConstants.RED, "powerOff");
        this.btnDphiOn = this.newButton("On", UiConstants.GREEN, "dphiOn");
        this.btnDphiOff = this.newButton("Off", UiConstants.RED, "dphiOff");
        this.btnBiasOn = this.newButton("On", UiConstants.GREEN, "hvBiasOn");
        this.btnBiasOff = this.newButton("Off", UiConstants.RED, "hvBiasOff");
        this.btnOtmOn = this.newButton("On", UiConstants.GREEN, "otmOn");
        this.btnOtmOff = this.newButton("Off", UiConstants.RED, "otmOff");
        this.btnFanOn = this.newButton("On", UiConstants.GREEN, "fanOn");
        this.btnFanOff = this.newButton("Off", UiConstants.RED, "fanOff");
        this.btnAuxOn = this.newButton("On", UiConstants.GREEN, "auxOn");
        this.btnAuxOff = this.newButton("Off", UiConstants.RED, "auxOff");
        JTextField tf = new JTextField("...");
        Dimension dd = tf.getPreferredSize();
        dd.width = 60;
        tf.setPreferredSize(dd);
        tf.setHorizontalAlignment(0);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.setDphiValue();
            }
        });
        this.tfDphiVal = tf;
        tf = new JTextField("...");
        tf.setPreferredSize(dd);
        tf.setHorizontalAlignment(0);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.setBiasValue();
            }
        });
        this.tfBiasVal = tf;
        for (int cs = 0; cs < this.lblChanStatus.length; ++cs) {
            JLabel lbl = new JLabel(SOLID_BAR);
            lbl.setFont(UiConstants.FONT);
            lbl.setFocusable(false);
            this.lblChanStatus[cs] = lbl;
        }
        JLabel lbl = new JLabel(SOLID_BAR);
        lbl.setFont(UiConstants.FONT);
        lbl.setFocusable(false);
        this.lblOtmStatus = lbl;
        lbl = new JLabel(SOLID_BAR);
        lbl.setFont(UiConstants.FONT);
        lbl.setFocusable(false);
        this.lblFanStatus = lbl;
        lbl = new JLabel(SOLID_BAR);
        lbl.setFont(UiConstants.FONT);
        lbl.setFocusable(false);
        this.lblAuxStatus = lbl;
        this.sysStatusPnl = new SystemStatusPanel(this.sender);
        JPanel pnlPowerControl = new JPanel();
        pnlPowerControl.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 6, 4, 6);
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        lbl = new JLabel("Seq. Power");
        lbl.setFont(UiConstants.FONT);
        pnlPowerControl.add((Component)lbl, gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        gbp.insets.right = 2;
        pnlPowerControl.add((Component)this.btnPowerOn, gbp);
        ++gbp.gridx;
        gbp.insets.left = 2;
        gbp.insets.right = 6;
        pnlPowerControl.add((Component)this.btnPowerOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        gbp.insets.left = 6;
        lbl = new JLabel("DPHI");
        lbl.setFont(UiConstants.FONT);
        pnlPowerControl.add((Component)lbl, gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        gbp.insets.right = 2;
        pnlPowerControl.add((Component)this.btnDphiOn, gbp);
        ++gbp.gridx;
        gbp.insets.left = 2;
        gbp.insets.right = 6;
        pnlPowerControl.add((Component)this.btnDphiOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        lbl = new JLabel("DPHI Volts");
        lbl.setFont(UiConstants.FONT);
        pnlPowerControl.add((Component)lbl, gbp);
        gbp.gridy = 1;
        pnlPowerControl.add((Component)this.tfDphiVal, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        gbp.insets.left = 6;
        lbl = new JLabel("HV Bias");
        lbl.setFont(UiConstants.FONT);
        pnlPowerControl.add((Component)lbl, gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        gbp.insets.right = 2;
        pnlPowerControl.add((Component)this.btnBiasOn, gbp);
        ++gbp.gridx;
        gbp.insets.left = 2;
        gbp.insets.right = 6;
        pnlPowerControl.add((Component)this.btnBiasOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.insets.left = 6;
        lbl = new JLabel("Bias Volts");
        lbl.setFont(UiConstants.FONT);
        pnlPowerControl.add((Component)lbl, gbp);
        gbp.gridy = 1;
        pnlPowerControl.add((Component)this.tfBiasVal, gbp);
        JPanel pnlChanStatus = new JPanel();
        pnlChanStatus.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.insets = new Insets(2, 6, 2, 6);
        gbs.gridx = 0;
        for (int j = 0; j < this.lblChanStatus.length; ++j) {
            gbs.gridy = 0;
            lbl = new JLabel(chanNames.get(j));
            lbl.setFont(UiConstants.FONT);
            pnlChanStatus.add((Component)lbl, gbs);
            gbs.gridy = 1;
            pnlChanStatus.add((Component)this.lblChanStatus[j], gbs);
            ++gbs.gridx;
        }
        JPanel pnlREBPower = new JPanel();
        TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), "REB Power");
        border.setTitleColor(UiConstants.BLUE);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleJustification(2);
        pnlREBPower.setBorder(border);
        pnlREBPower.setLayout(new GridBagLayout());
        GridBagConstraints gbrp = new GridBagConstraints();
        gbrp.insets = new Insets(0, 4, 4, 4);
        gbrp.gridx = 0;
        gbrp.gridy = 0;
        pnlREBPower.add((Component)pnlPowerControl, gbrp);
        ++gbrp.gridy;
        pnlREBPower.add((Component)pnlChanStatus, gbrp);
        JPanel pnlAncPower = new JPanel();
        border = new TitledBorder(new LineBorder(Color.BLACK), "Ancillary Power");
        border.setTitleColor(UiConstants.BLUE);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleJustification(2);
        pnlAncPower.setBorder(border);
        pnlAncPower.setLayout(new GridBagLayout());
        GridBagConstraints gbap = new GridBagConstraints();
        gbap.insets = new Insets(0, 6, 4, 6);
        gbap.gridx = 0;
        gbap.gridy = 0;
        gbap.gridwidth = 2;
        lbl = new JLabel("OTM");
        lbl.setFont(UiConstants.FONT);
        pnlAncPower.add((Component)lbl, gbap);
        ++gbap.gridy;
        gbap.gridwidth = 1;
        gbap.insets.right = 2;
        pnlAncPower.add((Component)this.btnOtmOn, gbap);
        ++gbap.gridx;
        gbap.insets.left = 2;
        gbap.insets.right = 6;
        pnlAncPower.add((Component)this.btnOtmOff, gbap);
        --gbap.gridx;
        ++gbap.gridy;
        gbap.gridwidth = 2;
        gbap.insets.left = 6;
        pnlAncPower.add((Component)this.lblOtmStatus, gbap);
        gbap.gridx = 2;
        gbap.gridy = 0;
        lbl = new JLabel("Fan");
        lbl.setFont(UiConstants.FONT);
        pnlAncPower.add((Component)lbl, gbap);
        ++gbap.gridy;
        gbap.gridwidth = 1;
        gbap.insets.right = 2;
        pnlAncPower.add((Component)this.btnFanOn, gbap);
        ++gbap.gridx;
        gbap.insets.left = 2;
        gbap.insets.right = 6;
        pnlAncPower.add((Component)this.btnFanOff, gbap);
        --gbap.gridx;
        ++gbap.gridy;
        gbap.gridwidth = 2;
        gbap.insets.left = 6;
        pnlAncPower.add((Component)this.lblFanStatus, gbap);
        gbap.gridx = 4;
        gbap.gridy = 0;
        gbap.gridwidth = 2;
        lbl = new JLabel("Aux");
        lbl.setFont(UiConstants.FONT);
        pnlAncPower.add((Component)lbl, gbap);
        ++gbap.gridy;
        gbap.gridwidth = 1;
        gbap.insets.right = 2;
        pnlAncPower.add((Component)this.btnAuxOn, gbap);
        ++gbap.gridx;
        gbap.insets.left = 2;
        gbap.insets.right = 6;
        pnlAncPower.add((Component)this.btnAuxOff, gbap);
        --gbap.gridx;
        ++gbap.gridy;
        gbap.gridwidth = 2;
        gbap.insets.left = 6;
        pnlAncPower.add((Component)this.lblAuxStatus, gbap);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 0, 4, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.sysStatusPnl, gbc);
        ++gbc.gridy;
        this.add((Component)pnlREBPower, gbc);
        ++gbc.gridy;
        this.add((Component)pnlAncPower, gbc);
    }

    private JButton newButton(String text, Color color, String command) {
        JButton btn = new JButton(text);
        btn.setFont(UiConstants.FONT);
        btn.setForeground(color);
        btn.setFocusable(false);
        btn.setActionCommand(command);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.sender.sendCommand(null, ((JButton)evt.getSource()).getActionCommand(), new Object[0]);
            }
        });
        return btn;
    }

    private void setBiasValue() {
        try {
            double value = Double.valueOf(this.tfBiasVal.getText());
            this.sender.sendCommand(null, "setHvBias", new Object[]{value});
        }
        catch (NumberFormatException nfe) {
            this.tfBiasVal.setText(String.format("%.1f", this.hvBias));
        }
    }

    private void setDphiValue() {
        try {
            double value = Double.valueOf(this.tfDphiVal.getText());
            this.sender.sendCommand(null, "setDphi", new Object[]{value});
        }
        catch (NumberFormatException nfe) {
            this.tfDphiVal.setText(String.format("%.1f", this.dphi));
        }
    }

    public void updateControlPanel(ATSPowerState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        chanNames.put(0, "Dig");
        chanNames.put(1, "Ana");
        chanNames.put(2, "ClkH");
        chanNames.put(3, "ClkL");
        chanNames.put(4, "OD");
        chanNames.put(5, "DPHI");
        chanNames.put(6, "HVbias");
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            ATSPowerControlPanel.this.sysStatusPnl.disableSystem();
            ATSPowerControlPanel.this.btnPowerOn.setEnabled(false);
            ATSPowerControlPanel.this.btnPowerOff.setEnabled(false);
            ATSPowerControlPanel.this.btnDphiOn.setEnabled(false);
            ATSPowerControlPanel.this.btnDphiOff.setEnabled(false);
            ATSPowerControlPanel.this.btnBiasOn.setEnabled(false);
            ATSPowerControlPanel.this.btnBiasOff.setEnabled(false);
            ATSPowerControlPanel.this.tfBiasVal.setEnabled(false);
            ATSPowerControlPanel.this.tfDphiVal.setEnabled(false);
            for (JLabel lbl : ATSPowerControlPanel.this.lblChanStatus) {
                lbl.setEnabled(false);
            }
            ATSPowerControlPanel.this.btnOtmOn.setEnabled(false);
            ATSPowerControlPanel.this.btnOtmOff.setEnabled(false);
            ATSPowerControlPanel.this.btnFanOn.setEnabled(false);
            ATSPowerControlPanel.this.btnFanOff.setEnabled(false);
            ATSPowerControlPanel.this.btnAuxOn.setEnabled(false);
            ATSPowerControlPanel.this.btnAuxOff.setEnabled(false);
            ATSPowerControlPanel.this.lblOtmStatus.setEnabled(false);
            ATSPowerControlPanel.this.lblFanStatus.setEnabled(false);
            ATSPowerControlPanel.this.lblAuxStatus.setEnabled(false);
            ATSPowerControlPanel.this.repaint();
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final ATSPowerState rs;

        UpdatePowerStatus(ATSPowerState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ATSPowerControlPanel.this.sysStatusPnl.updateStatus(this.rs.getTickMillis());
            ATSPowerControlPanel.this.btnPowerOn.setEnabled(true);
            ATSPowerControlPanel.this.btnPowerOff.setEnabled(true);
            ATSPowerControlPanel.this.btnDphiOn.setEnabled(true);
            ATSPowerControlPanel.this.btnDphiOff.setEnabled(true);
            ATSPowerControlPanel.this.btnBiasOn.setEnabled(true);
            ATSPowerControlPanel.this.btnBiasOff.setEnabled(true);
            ATSPowerControlPanel.this.hvBias = this.rs.getHvBias();
            ATSPowerControlPanel.this.tfBiasVal.setText(String.valueOf(ATSPowerControlPanel.this.hvBias));
            ATSPowerControlPanel.this.tfBiasVal.setEnabled(true);
            ATSPowerControlPanel.this.dphi = this.rs.getDphi();
            ATSPowerControlPanel.this.tfDphiVal.setText(String.valueOf(ATSPowerControlPanel.this.dphi));
            ATSPowerControlPanel.this.tfDphiVal.setEnabled(true);
            Boolean[] state = this.rs.getPowerState();
            for (int j = 0; j < ATSPowerControlPanel.this.lblChanStatus.length; ++j) {
                ATSPowerControlPanel.this.lblChanStatus[j].setForeground(state[j] == null ? UiConstants.BLUE : (state[j] != false ? UiConstants.GREEN : UiConstants.RED));
                ATSPowerControlPanel.this.lblChanStatus[j].setEnabled(true);
            }
            ATSPowerControlPanel.this.btnOtmOn.setEnabled(true);
            ATSPowerControlPanel.this.btnOtmOff.setEnabled(true);
            ATSPowerControlPanel.this.btnFanOn.setEnabled(true);
            ATSPowerControlPanel.this.btnFanOff.setEnabled(true);
            ATSPowerControlPanel.this.btnAuxOn.setEnabled(true);
            ATSPowerControlPanel.this.btnAuxOff.setEnabled(true);
            ATSPowerControlPanel.this.lblOtmStatus.setForeground(state[7] == null ? UiConstants.BLUE : (state[7] != false ? UiConstants.GREEN : UiConstants.RED));
            ATSPowerControlPanel.this.lblOtmStatus.setEnabled(true);
            ATSPowerControlPanel.this.lblFanStatus.setForeground(state[8] == null ? UiConstants.BLUE : (state[8] != false ? UiConstants.GREEN : UiConstants.RED));
            ATSPowerControlPanel.this.lblFanStatus.setEnabled(true);
            ATSPowerControlPanel.this.lblAuxStatus.setForeground(state[9] == null ? UiConstants.BLUE : (state[9] != false ? UiConstants.GREEN : UiConstants.RED));
            ATSPowerControlPanel.this.lblAuxStatus.setEnabled(true);
            ATSPowerControlPanel.this.repaint();
        }
    }
}

