/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.constants.QuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;

public class QuadBoxControlPanel
extends JPanel {
    private static final String[] panelNames = new String[6];
    private static final Map<Integer, String> switchNames;
    private static final int[] nameWidths;
    private static final Map<Integer, Integer> bfrSwitchMap;
    private static final Map<Integer, Integer> mainSwitchMap;
    private final CommandSender sender;
    private final JPanel topPanel = new JPanel();
    private final JPanel statePanel = new JPanel();
    private final JLabel stateLabel = new JLabel("System State: ");
    private final JLabel stateStatus = new JLabel("....");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField("...");
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel[] switchPanel = new JPanel[6];
    private final JLabel[][] switchLabel = new JLabel[6][];
    private final JLabel[][] switchStatus = new JLabel[6][];
    private final ButtonGroup[][] switchBG = new ButtonGroup[6][];
    private final JRadioButton[][] switchOffRB = new JRadioButton[6][];
    private final JRadioButton[][] switchOnRB = new JRadioButton[6][];
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private double powerPeriod = 5.0;
    private static final long serialVersionUID = 1L;

    public QuadBoxControlPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new UpdatePowerStatus(new QuadBoxState()).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        int dvc;
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 70;
        this.stateStatus.setPreferredSize(d);
        this.stateStatus.setMinimumSize(d);
        d = this.periodTextField.getPreferredSize();
        d.width = 50;
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuadBoxControlPanel.this.setUpdatePeriod();
            }
        });
        for (int dvc2 = 0; dvc2 < 6; ++dvc2) {
            int nSwitch = QuadBoxSwitches.NUM_SWITCHES[dvc2];
            this.switchLabel[dvc2] = new JLabel[nSwitch + 1];
            this.switchStatus[dvc2] = new JLabel[nSwitch + 1];
            this.switchBG[dvc2] = new ButtonGroup[nSwitch + 1];
            this.switchOnRB[dvc2] = new JRadioButton[nSwitch + 1];
            this.switchOffRB[dvc2] = new JRadioButton[nSwitch + 1];
        }
        int[] lines = new int[6];
        for (int swId : switchNames.keySet()) {
            int line;
            int n = dvc = swId >> 8;
            lines[n] = lines[n] + 1;
            this.switchLines.put(swId, line);
            JLabel jLabel = new JLabel(switchNames.get(swId));
            this.switchLabel[dvc][line] = jLabel;
            JLabel label = jLabel;
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = nameWidths[dvc];
            label.setPreferredSize(d);
            label.setMinimumSize(d);
            JLabel jLabel2 = new JLabel("XXX");
            this.switchStatus[dvc][line] = jLabel2;
            JLabel status = jLabel2;
            status.setFont(UiConstants.FONT);
            d = status.getPreferredSize();
            d.width = 64;
            status.setPreferredSize(d);
            status.setMinimumSize(d);
            JRadioButton jRadioButton = new JRadioButton("On");
            this.switchOnRB[dvc][line] = jRadioButton;
            JRadioButton on = jRadioButton;
            on.setFont(UiConstants.FONT);
            on.setFocusable(false);
            on.setName(Integer.toString(swId));
            on.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    QuadBoxControlPanel.this.setSwitchOn(Integer.valueOf(name), true);
                }
            });
            JRadioButton jRadioButton2 = new JRadioButton("Off");
            this.switchOffRB[dvc][line] = jRadioButton2;
            JRadioButton off = jRadioButton2;
            off.setFont(UiConstants.FONT);
            off.setFocusable(false);
            off.setName(Integer.toString(swId));
            off.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    QuadBoxControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            this.switchBG[dvc][line] = buttonGroup;
            ButtonGroup bg = buttonGroup;
            bg.add(on);
            bg.add(off);
        }
        this.statePanel.add(this.stateLabel);
        this.statePanel.add(this.stateStatus);
        this.periodPanel.add(this.periodLabel);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        GridBagConstraints gbt = new GridBagConstraints();
        this.topPanel.setLayout(new GridBagLayout());
        gbt.gridx = 0;
        gbt.gridy = 0;
        this.topPanel.add((Component)this.statePanel, gbt);
        gbt.insets.left = 80;
        ++gbt.gridx;
        this.topPanel.add((Component)this.periodPanel, gbt);
        GridBagConstraints gbs = new GridBagConstraints();
        for (dvc = 0; dvc < 6; ++dvc) {
            JPanel panel = this.switchPanel[dvc] = new JPanel();
            TitledBorder border = new TitledBorder(new LineBorder(Color.BLACK), panelNames[dvc]);
            border.setTitleColor(UiConstants.BLUE);
            panel.setBorder(border);
            panel.setLayout(new GridBagLayout());
            gbs.gridy = 0;
            gbs.insets.top = 0;
            for (int line = 0; line < this.switchLabel[dvc].length; ++line) {
                if (this.switchLabel[dvc][line] == null) continue;
                gbs.gridx = 0;
                gbs.insets.left = 4;
                gbs.insets.right = 0;
                panel.add((Component)this.switchLabel[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.left = 0;
                panel.add((Component)this.switchStatus[dvc][line], gbs);
                ++gbs.gridx;
                gbs.insets.right = 4;
                panel.add((Component)this.switchOffRB[dvc][line], gbs);
                ++gbs.gridx;
                panel.add((Component)this.switchOnRB[dvc][line], gbs);
                ++gbs.gridy;
                gbs.insets.top = -4;
            }
            panel.setMinimumSize(panel.getPreferredSize());
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.topPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.switchPanel[0], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[1], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[2], gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)this.switchPanel[5], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[3], gbc);
        ++gbc.gridx;
        this.add((Component)this.switchPanel[4], gbc);
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.powerPeriod));
        }
    }

    private void setSwitchOn(int swId, boolean on) {
        this.sender.sendCommand(null, "setNamedSwitchOn", new Object[]{QuadBoxSwitches.switchIdToName.get(swId), on});
    }

    public void updateControlPanel(QuadBoxState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        QuadBoxControlPanel.panelNames[0] = "BFR";
        QuadBoxControlPanel.panelNames[1] = "5V Clean PDU";
        QuadBoxControlPanel.panelNames[2] = "24V Clean PDU";
        QuadBoxControlPanel.panelNames[3] = "24V Dirty PDU";
        QuadBoxControlPanel.panelNames[4] = "48V Dirty PDU";
        QuadBoxControlPanel.panelNames[5] = "REB Bulk PS";
        switchNames = new LinkedHashMap<Integer, String>();
        switchNames.put(11, "5V Clean PDU");
        switchNames.put(10, "24V Clean PDU");
        switchNames.put(3, "24V Dirty PDU");
        switchNames.put(2, "48V Dirty PDU");
        switchNames.put(5, "REB PS 0-2");
        switchNames.put(6, "REB PS 3-5");
        switchNames.put(7, "REB PS 6-8");
        switchNames.put(8, "REB PS 9-12");
        switchNames.put(4, "Trim Heaters");
        switchNames.put(0, "Heater 1");
        switchNames.put(1, "Heater 2");
        switchNames.put(9, "REB PS spare");
        switchNames.put(264, "OTM 0-A");
        switchNames.put(265, "OTM 0-B");
        switchNames.put(266, "OTM 1-A");
        switchNames.put(267, "OTM 1-B");
        switchNames.put(268, "OTM 2-A");
        switchNames.put(269, "OTM 2-B");
        switchNames.put(270, "OTM 3-A");
        switchNames.put(271, "OTM 3-B");
        switchNames.put(272, "OTM 4-A");
        switchNames.put(273, "OTM 4-B");
        switchNames.put(274, "OTM 5-A");
        switchNames.put(275, "OTM 5-B");
        switchNames.put(767, "Main");
        switchNames.put(522, "Power/Cryo HCUs");
        switchNames.put(523, "FES/Shutter HCUs");
        switchNames.put(512, "Ion pumps");
        switchNames.put(520, "Body purge");
        switchNames.put(515, "BPU MAQ20");
        switchNames.put(521, "Gauges");
        switchNames.put(518, "FES carousel");
        switchNames.put(514, "FES changer");
        switchNames.put(519, "FES loader");
        switchNames.put(516, "Shutter 1");
        switchNames.put(517, "Shutter 2");
        switchNames.put(1023, "Main");
        switchNames.put(770, "Cryo turbo");
        switchNames.put(771, "Hex turbo");
        switchNames.put(772, "FES clamps");
        switchNames.put(773, "FES brake");
        switchNames.put(769, "FES changer");
        switchNames.put(768, "FES loader");
        switchNames.put(774, "Shutter brake");
        switchNames.put(1279, "Main");
        switchNames.put(1028, "Purge fan");
        switchNames.put(1024, "FES carousel");
        switchNames.put(1029, "FES heater");
        switchNames.put(1026, "Shutter 1");
        switchNames.put(1027, "Shutter 2");
        switchNames.put(1280, "REB PS 0-2");
        switchNames.put(1281, "REB PS 3-5");
        switchNames.put(1282, "REB PS 6-8");
        switchNames.put(1283, "REB PS 9-12");
        switchNames.put(1284, "REB PS Spare");
        nameWidths = new int[6];
        QuadBoxControlPanel.nameWidths[0] = 110;
        QuadBoxControlPanel.nameWidths[1] = 70;
        QuadBoxControlPanel.nameWidths[2] = 130;
        QuadBoxControlPanel.nameWidths[3] = 105;
        QuadBoxControlPanel.nameWidths[4] = 105;
        QuadBoxControlPanel.nameWidths[5] = 110;
        bfrSwitchMap = new HashMap<Integer, Integer>();
        bfrSwitchMap.put(1, 11);
        bfrSwitchMap.put(2, 10);
        bfrSwitchMap.put(3, 3);
        bfrSwitchMap.put(4, 2);
        mainSwitchMap = new HashMap<Integer, Integer>();
        mainSwitchMap.put(2, 767);
        mainSwitchMap.put(3, 1023);
        mainSwitchMap.put(4, 1279);
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            QuadBoxControlPanel.this.stateStatus.setText("STOPPED");
            QuadBoxControlPanel.this.stateStatus.setForeground(UiConstants.RED);
            QuadBoxControlPanel.this.periodTextField.setEnabled(false);
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int dvc = swId >> 8;
                int line = (Integer)QuadBoxControlPanel.this.switchLines.get(swId);
                QuadBoxControlPanel.this.switchStatus[dvc][line].setEnabled(false);
                QuadBoxControlPanel.this.switchOffRB[dvc][line].setEnabled(false);
                QuadBoxControlPanel.this.switchOnRB[dvc][line].setEnabled(false);
            }
            QuadBoxControlPanel.this.repaint();
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final QuadBoxState qs;

        UpdatePowerStatus(QuadBoxState qs) {
            this.qs = qs;
        }

        @Override
        public void run() {
            QuadBoxControlPanel.this.stateStatus.setText("RUNNING");
            QuadBoxControlPanel.this.stateStatus.setForeground(UiConstants.GREEN);
            QuadBoxControlPanel.this.periodTextField.setEnabled(true);
            QuadBoxControlPanel.this.powerPeriod = (double)this.qs.getTickMillis() / 1000.0;
            QuadBoxControlPanel.this.periodTextField.setText(String.valueOf(QuadBoxControlPanel.this.powerPeriod));
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int devc = swId >> 8;
                int line = (Integer)QuadBoxControlPanel.this.switchLines.get(swId);
                SwitchState st = this.qs.getSwitchState(swId);
                st = st == null ? SwitchState.OFFLINE : st;
                JLabel label = QuadBoxControlPanel.this.switchStatus[devc][line];
                label.setText(st.toString());
                label.setForeground(st == SwitchState.ON ? UiConstants.GREEN : (st == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
                if (st != SwitchState.OFFLINE) {
                    JRadioButton selButton = st == SwitchState.ON ? QuadBoxControlPanel.this.switchOnRB[devc][line] : QuadBoxControlPanel.this.switchOffRB[devc][line];
                    selButton.setSelected(true);
                }
                QuadBoxControlPanel.this.switchStatus[devc][line].setEnabled(true);
                QuadBoxControlPanel.this.switchOffRB[devc][line].setEnabled(true);
                QuadBoxControlPanel.this.switchOnRB[devc][line].setEnabled(true);
            }
            iterator = bfrSwitchMap.keySet().iterator();
            while (iterator.hasNext()) {
                String suffix;
                SwitchState mainSwSt;
                int devc = (Integer)iterator.next();
                SwitchState bfrSwSt = this.qs.getSwitchState(((Integer)bfrSwitchMap.get(devc)).intValue());
                Integer mainSwId = (Integer)mainSwitchMap.get(devc);
                SwitchState switchState = mainSwSt = mainSwId == null ? SwitchState.ON : this.qs.getSwitchState(mainSwId.intValue());
                String string = bfrSwSt != SwitchState.ON ? " (BFR off)" : (suffix = mainSwSt != SwitchState.ON ? " (Main off)" : "");
                Color color = bfrSwSt != SwitchState.ON ? UiConstants.RED : (mainSwSt != SwitchState.ON ? UiConstants.PURPLE : UiConstants.BLUE);
                JPanel panel = QuadBoxControlPanel.this.switchPanel[devc];
                TitledBorder border = (TitledBorder)panel.getBorder();
                border.setTitle(panelNames[devc] + suffix);
                border.setTitleColor(color);
            }
            QuadBoxControlPanel.this.repaint();
        }
    }
}

