/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPage;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

final class MonitorPageDialog
extends JDialog {
    private final String defaultName = "Monitor";
    private final PersistenceService service = Console.getConsole().getSingleton(PersistenceService.class);
    private String viewCategory;
    private String filterCategory;
    private PersistableMonitorView view;
    private PersistableAgentChannelsFilter filter;
    private final MonitorPage.Descriptor descriptor;
    private MonitorPage page;
    private JTextField nameField;
    private JTextField viewField;
    private JTextField filterField;

    private MonitorPageDialog(MonitorPage.Descriptor before, String title, Component parent) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), title == null ? "Open new monitoring page" : title, Dialog.ModalityType.APPLICATION_MODAL);
        String name;
        String viewName = "";
        String filterName = "";
        this.descriptor = before;
        Persistable.Descriptor desc = this.descriptor.getView();
        if (desc != null && desc.getCategory() != null) {
            this.viewCategory = desc.getCategory();
            try {
                this.view = (PersistableMonitorView)this.service.make(desc);
                name = this.view.getName();
                viewName = name == null || name.trim().isEmpty() ? this.view.getClass().getSimpleName() : name;
            }
            catch (RuntimeException x) {
                this.view = null;
            }
        } else {
            this.viewCategory = "MonitorView";
            this.view = (PersistableMonitorView)this.service.make("MonitorView", "Built-In/Default", new Object[0]);
            viewName = this.view.getName();
        }
        if ((desc = this.descriptor.getFilter()) != null && desc.getCategory() != null) {
            this.filterCategory = desc.getCategory();
            try {
                this.filter = (PersistableAgentChannelsFilter)this.service.make(desc);
                name = this.filter.getName();
                filterName = name == null || name.trim().isEmpty() ? this.filter.getClass().getSimpleName() : name;
            }
            catch (RuntimeException x) {
                this.filter = null;
            }
        } else {
            this.filterCategory = "AgentChannelsFilter";
            this.filter = (PersistableAgentChannelsFilter)this.service.make("AgentChannelsFilter", "Built-In/Unfiltered", new Object[0]);
            filterName = this.filter.getName();
        }
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 8, 3, 8);
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        JLabel label = new JLabel("Page name:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.gridy = 1;
        label = new JLabel("View type:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.gridy = 2;
        label = new JLabel("Filter:");
        gridbag.setConstraints(label, c);
        this.add(label);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        this.nameField = new JTextField(this.descriptor.getName() == null ? this.defaultName : this.descriptor.getName(), 50);
        gridbag.setConstraints(this.nameField, c);
        this.add(this.nameField);
        c.gridy = 1;
        this.viewField = new JTextField(viewName, 50);
        this.viewField.setEditable(false);
        gridbag.setConstraints(this.viewField, c);
        this.add(this.viewField);
        c.gridy = 2;
        this.filterField = new JTextField(filterName, 50);
        this.filterField.setEditable(false);
        gridbag.setConstraints(this.filterField, c);
        this.add(this.filterField);
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.gridy = 1;
        JButton button = new JButton("Choose...");
        button.setToolTipText("Select view type");
        button.addActionListener(e -> {
            PersistableMonitorView v;
            try {
                v = this.view == null ? (PersistableMonitorView)this.service.make(this.descriptor.getView(), title, parent, this.viewCategory) : this.view.edit(title, parent);
            }
            catch (RuntimeException x) {
                v = null;
            }
            if (v != null) {
                this.view = v;
                this.descriptor.setView(this.view.save());
                String name = this.view.getName();
                if (name == null || name.trim().isEmpty()) {
                    name = this.view.getClass().getSimpleName();
                }
                this.viewField.setText(name);
            }
        });
        gridbag.setConstraints(button, c);
        this.add(button);
        c.gridy = 2;
        button = new JButton("Choose...");
        button.setToolTipText("Select filter");
        button.addActionListener(e -> {
            PersistableAgentChannelsFilter f;
            try {
                f = this.filter == null ? (PersistableAgentChannelsFilter)this.service.make(this.descriptor.getFilter(), title, parent, this.filterCategory) : (PersistableAgentChannelsFilter)this.filter.edit(title, parent);
            }
            catch (RuntimeException x) {
                f = null;
            }
            if (f != null) {
                this.filter = f;
                this.descriptor.setFilter((Persistable.Descriptor)this.filter.save());
                String name = this.filter.getName();
                if (name == null || name.trim().isEmpty()) {
                    name = this.filter.getClass().getSimpleName();
                }
                this.filterField.setText(name);
            }
        });
        gridbag.setConstraints(button, c);
        this.add(button);
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 14;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.insets = new Insets(16, 8, 4, 8);
        JPanel box = new JPanel();
        box.setLayout(new GridLayout(1, 2, 16, 5));
        button = new JButton("Cancel");
        button.addActionListener(e -> {
            this.view = null;
            this.filter = null;
            this.page = null;
            this.dispose();
        });
        box.add(button);
        button = new JButton("OK");
        button.addActionListener(e -> {
            if (this.done()) {
                this.dispose();
            }
        });
        box.add(button);
        gridbag.setConstraints(box, c);
        this.add(box);
    }

    static MonitorPage edit(MonitorPage page, String title, Component parentComponent) {
        MonitorPage.Descriptor before = page == null ? new MonitorPage.Descriptor() : page.save();
        MonitorPageDialog dialog = new MonitorPageDialog(before, title, parentComponent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
        if (dialog.page == null) {
            throw new CancellationException();
        }
        return dialog.page;
    }

    private boolean done() {
        if (this.view == null) {
            Console.getConsole().error("Please select view type");
            return false;
        }
        if (this.filter == null) {
            Console.getConsole().error("Please select filter");
            return false;
        }
        String name = this.nameField.getText();
        if (!name.trim().isEmpty()) {
            this.descriptor.setName(name);
        }
        try {
            this.page = new MonitorPage(this.descriptor);
        }
        catch (RuntimeException x) {
            Console.getConsole().error("Cannot create motinor page", x);
            return false;
        }
        return true;
    }
}

