/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.data.BasicState;
import org.lsst.ccs.subsystem.common.ui.BasicControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;

public class BasicPlugin
extends ConsolePlugin {
    private final String agentProperty;
    private final String section;

    public BasicPlugin(String agentProperty, String section) {
        this.agentProperty = agentProperty;
        this.section = section;
    }

    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage(this.agentProperty, BasicControl.class, this.section, true, "BasicState"));
    }

    public static class BasicControl
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private BasicControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("BasicState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new BasicControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getFullState", new Object[0]));
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((BasicState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

