/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.List;
import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.power.ui.PowerControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.ui.jas.Control;
import org.lsst.ccs.subsystem.power.ui.jas.MonitorOptionalPage;

@Plugin(name="CCS Power Supply Plugin", description="CCS Power Supply Plugin")
public class PowerControlPlugin
extends ConsolePlugin {
    public void initialize() {
        MonitorOptionalPage optPage = new MonitorOptionalPage("powerAgent", PowerControl.class, null, null);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class PowerControl
    implements Control,
    StatusMessageListener {
        private CommandSender cmdSender;
        private PowerControlPanel ctrlPanel;

        PowerControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("PowerChanState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new PowerControlPanel(sndr, false);
            return this.ctrlPanel;
        }

        @Override
        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getFullState", new Object[0]));
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((List)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

