package org.lsst.ccs.subsystem.power.ui.jas;

import java.awt.BorderLayout;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.filter.GenericFilter;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentMessagingLayer;

/**
 * @author tonyj
 */
public class MonitorOptionalPage implements OptionalPage {

    private final Map<String, Control> controls = new ConcurrentHashMap<>();
    private final String agentProperty;
    private final Class controlClass, filterClass;
    //private final boolean addMonitor;
    private final String pageNode;

    public MonitorOptionalPage(String agentProperty, Class controlClass, Class filterClass, String pageNode) {
        this.agentProperty = agentProperty;
        this.controlClass = controlClass;
        this.filterClass = filterClass;
        this.pageNode = pageNode;
    }

    @Override
    public boolean isAutoOpen() {
        return false;
    }

    @Override
    public String getPage(AgentInfo agent) {
        return agent != null && agent.hasAgentProperty(agentProperty) ? getPageName(agent) : null;
    }

    @Override
    public boolean agentDisconnected(AgentInfo agent) {
        Control control = controls.get(getPageName(agent));
        if (control == null) return true;
        control.disableSystem();
        return false;
    }

    @Override
    public JComponent open(AgentInfo agent, JComponent existingComponent) {
        String pageName = getPageName(agent);
        String agentName = agent.getName();
        Control control = controls.get(pageName);
        if (control != null) {
            control.initControlPanel();
            return existingComponent;
        }

        // Create the control object
        try {
            control = (Control)controlClass.newInstance();
            controls.put(pageName, control);
        }
        catch (Exception e) {
            return null;
        }

        // Create the control panel
        JPanel cPanel = control.getControlPanel(new CommandSender(agentName));
        control.initControlPanel();

        // Create the monitoring panel, if requested, and fill top panel
        JPanel panel;
        if (filterClass != null) {
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            try {
                view.setFilter((GenericFilter)filterClass.getConstructor(String.class).newInstance(agentName));
            }
            catch (Exception e) {
                return null;
            }
            view.install();
            panel = new JPanel();
            panel.setLayout(new java.awt.BorderLayout());
            panel.add(view.getPanel(), BorderLayout.CENTER);
            panel.add(cPanel, BorderLayout.SOUTH);
        }
        else {
            panel = cPanel;
        }
        if (pageNode != null && !pageNode.isEmpty()) {
            panel.setName(agentName + " " + pageNode);
        }

        // Set up the bus listener
        AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
        aml.addStatusMessageListener(control.getListener(),
                                     (msg) -> msg.getOriginAgentInfo().getName().equals(agentName)
                                                && msg instanceof StatusSubsystemData);

        return panel;
    }

    @Override
    public void closed(String pageName) {
        Control control = controls.remove(pageName);
        if (control == null) {
            throw new RuntimeException("No page exists with the name " + pageName);
        }
        Console.getConsole().getMessagingAccess().removeStatusMessageListener(control.getListener());
    }

    private String getPageName(AgentInfo agent) {
        return "CCS Subsystems/" + agent.getName();
    }

}
