/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.subsystem.power.ui.RebPsControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.ui.jas.Control;
import org.lsst.ccs.subsystem.power.ui.jas.PowerOptionalPage;

@Plugin(name="CCS Reb Power Supply Plugin", description="CCS Reb Power Supply Plugin")
public class RebPsControlPlugin
extends ConsolePlugin {
    public void initialize() {
        PowerOptionalPage optPage = new PowerOptionalPage("rebPowerAgent", RebPsControl.class);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class RebPsControl
    implements Control,
    StatusMessageListener {
        private RebPsControlPanel ctrlPanel;

        RebPsControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("RebPsState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((RebPsState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.ctrlPanel = new RebPsControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void setSubsystems(String name) {
            this.ctrlPanel.setSubsystems(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

