package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.power.constants.PowerAgentProperties;
import org.lsst.ccs.subsystem.power.ui.PowerControlGui;

/**
 * This needs work!!!
 *
 * @author tonyj
 */
@Plugin(name = "CCS Power Supply Plugin", description = "CCS Power Supply Plugin")
public class PowerControlPlugin extends ConsolePlugin {
    
    @Override
    public void initialize() {
        Console.getConsole().getOptionalPageService().add(new PowerControlOptionalPage());
    }


    static class PowerControlOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent == null || !agent.hasAgentProperty(PowerAgentProperties.POWER_AGENT)) return null;
            return "CCS Subsystems/"+agent.getName()+"/Control";
        }

        @Override        
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();            
            PowerControlGui gui = new PowerControlGui(agentName);
            gui.initGui();
            String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Control";
            gui.getGuiLayout().setName(title);
            return gui.getGuiLayout();
        }
        
    }
    
}
