/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayerMBean;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentMessagingLayer
implements AgentMessagingLayerMBean {
    private static final List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<AgentMessagingLayer>();
    private Predicate<BusMessage<? extends Serializable, ?>> filterMessagesFromThisAgent;
    private final Logger curLogger = Logger.getLogger((String)"org.lsst.ccs.bus");
    private final BusApplicationLayer layer;
    private volatile boolean isConnected = false;
    private final AgentInfo agentInfo;
    private final LockLevelService lockLevelService;

    public static AgentMessagingLayer createInstance(AgentInfo agentInfo, LockLevelService lockLevelService) {
        AgentMessagingLayer agentMessagingLayer = new AgentMessagingLayer(agentInfo, lockLevelService);
        return agentMessagingLayer;
    }

    AgentMessagingLayer(AgentInfo agentInfo, LockLevelService lockLevelService) {
        this.layer = new BusApplicationLayer(agentInfo);
        this.filterMessagesFromThisAgent = BusMessageFilterFactory.messageOrigin(agentInfo.getName()).negate();
        this.agentInfo = agentInfo;
        this.lockLevelService = lockLevelService;
    }

    @Override
    public void restart(int seconds) {
        this.shutdownBusAccess();
        Thread restart = new Thread(() -> {
            try {
                Thread.sleep(1000 * seconds);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            this.connectToBuses();
        });
    }

    BusApplicationLayer getApplicationLayer() {
        return this.layer;
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    public void shutdownBusAccess() {
        this.isConnected = false;
        this.layer.close();
        msgAccesses.remove(this);
    }

    public void connectToBuses() {
        this.layer.connectToBuses();
        msgAccesses.add(this);
        this.isConnected = true;
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.layer.getAgentPresenceManager();
    }

    public LockLevelService getAgentLockService() {
        return this.lockLevelService;
    }

    public void addLogMessageListener(LogMessageListener listener) {
        this.addLogMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addLogMessageListener(LogMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addLogListener(listener, filter);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.addStatusMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addStatusMessageListener(StatusMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addStatusListener(listener, filter);
    }

    public void addCommandMessageListener(CommandMessageListener listener) {
        this.addCommandMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addCommandMessageListener(CommandMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addCommandListener(listener, filter);
    }

    public void removeLogMessageListener(LogMessageListener listener) {
        this.layer.removeLogListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.layer.removeStatusListener(listener);
    }

    public void removeCommandMessageListener(CommandMessageListener listener) {
        this.layer.removeCommandListener(listener);
    }

    public void sendLogMessage(LogMessage msg) {
        if (!this.isConnected) {
            throw new RuntimeException("A connection to the buses has not been established yet.");
        }
        msg.setOriginAgentInfo(this.agentInfo);
        this.layer.sendLog(msg);
    }

    public void sendStatusMessage(StatusMessage msg) {
        if (!this.isConnected) {
            throw new RuntimeException("A connection to the buses has not been established yet.");
        }
        msg.setOriginAgentInfo(this.agentInfo);
        this.curLogger.finest((Object)("sending status " + msg));
        this.layer.sendStatus(msg);
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator) {
        if (!this.isConnected) {
            throw new RuntimeException("A connection to the buses has not been established yet.");
        }
        if (this.lockLevelService != null) {
            String destination = BusMessagingLayer.parseDestination(cmd.getDestination());
            AgentLock lock = this.lockLevelService.getLockForAgent(destination);
            int desiredLevel = this.lockLevelService.getLevelForAgent(destination);
            cmd.setLockAndLevel(lock, desiredLevel);
        }
        cmd.setOriginAgentInfo(this.agentInfo);
        this.layer.sendCommand(cmd, originator);
    }

    public void sendCommandReply(CommandReply reply) {
        if (!this.isConnected) {
            throw new RuntimeException("A connection to the buses has not been established yet.");
        }
        reply.setOriginAgentInfo(this.agentInfo);
        this.layer.reply(reply);
    }

    public void setCommandExecutor(CommandExecutor executor) {
        this.layer.setCommandExecutor(executor);
    }

    public void setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler h) {
        this.layer.setClusterDeserializationErrorHandler(h);
    }

    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;
    }

    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess " + msgAccess.agentInfo.getName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer " + layer);
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer " + messagingLayer);
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents " + localAgents.size());
        for (String agent : localAgents) {
            System.out.println("\t" + agent);
        }
    }
}

