/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;
import org.lsst.ccs.subsystem.power.ui.QuadBoxControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.ui.jas.Control;
import org.lsst.ccs.subsystem.power.ui.jas.PowerOptionalPage;

@Plugin(name="Quadbox Control Plugin", description="Quadbox Control Plugin")
public class QuadBoxControlPlugin
extends ConsolePlugin {
    public void initialize() {
        PowerOptionalPage optPage = new PowerOptionalPage("quadBoxAgent", QuadBoxControl.class);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class QuadBoxControl
    implements Control,
    StatusMessageListener {
        private QuadBoxControlPanel ctrlPanel;

        QuadBoxControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("QuadBoxState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((QuadBoxState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.ctrlPanel = new QuadBoxControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void setSubsystems(String name) {
            this.ctrlPanel.setSubsystems(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

