/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.power.ui.PowerControlGui;

@Plugin(name="CCS Power Supply Plugin", description="CCS Power Supply Plugin")
public class PowerControlPlugin
extends ConsolePlugin {
    public void initialize() {
        Console.getConsole().getOptionalPageService().add((OptionalPage)new PowerControlOptionalPage());
    }

    static class PowerControlOptionalPage
    implements OptionalPage {
        PowerControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent == null || !agent.hasAgentProperty("powerAgent")) {
                return null;
            }
            return "CCS Subsystems/" + agent.getName() + "/Control";
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            PowerControlGui gui = new PowerControlGui(agentName);
            gui.initGui();
            String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Control";
            gui.getGuiLayout().setName(title);
            return gui.getGuiLayout();
        }
    }
}

