/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;
import org.lsst.ccs.subsystem.power.ui.QuadBoxControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.ui.jas.MonitorFilter;

@Plugin(name="Quadbox Control Plugin", description="Quadbox Control Plugin")
public class QuadBoxControlPlugin
extends ConsolePlugin {
    public void initialize() {
        Console.getConsole().getOptionalPageService().add((OptionalPage)new QuadboxControlOptionalPage());
    }

    static class BusListener
    implements StatusMessageListener {
        private final QuadBoxControlPanel controls;

        BusListener(QuadBoxControlPanel controls) {
            this.controls = controls;
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("QuadBoxState")) {
                    this.controls.updateControlPanel((QuadBoxState)sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }
    }

    static class QuadboxControlOptionalPage
    implements OptionalPage {
        private final CommandSender cmdSender = new CommandSender();
        private final Map<String, BusListener> busListeners = new ConcurrentHashMap<String, BusListener>();

        QuadboxControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("quadBoxAgent") ? this.getPageName(agent) : null;
        }

        public boolean agentDisconnected(AgentInfo agent) {
            BusListener listener = this.busListeners.get(this.getPageName(agent));
            if (listener == null) {
                return true;
            }
            listener.controls.disableSystem();
            return false;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String pageName = this.getPageName(agent);
            String agentName = agent.getName();
            BusListener listener = this.busListeners.get(pageName);
            if (listener != null) {
                this.initControls(agentName, listener.controls);
                return existingComponent;
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            MonitorFilter monitorFilter = new MonitorFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            panel.add((Component)view.getPanel(), "Center");
            QuadBoxControlPanel controls = new QuadBoxControlPanel(this.cmdSender);
            controls.setSubsystems(agent.getName());
            panel.add((Component)controls, "South");
            listener = new BusListener(controls);
            AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
            aml.addStatusMessageListener((StatusMessageListener)listener, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            this.busListeners.put(pageName, listener);
            this.initControls(agentName, controls);
            return panel;
        }

        public void closed(String pageName) {
            BusListener listener = this.busListeners.remove(pageName);
            if (listener == null) {
                throw new RuntimeException("No page exists with the name " + pageName);
            }
            Console.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
        }

        private String getPageName(AgentInfo agent) {
            return "CCS Subsystems/" + agent.getName();
        }

        private void initControls(String agentName, QuadBoxControlPanel controls) {
            Object response = this.cmdSender.sendCommand(agentName, null, "getFullState", new Object[0]);
            if (response instanceof QuadBoxState) {
                controls.updateControlPanel((QuadBoxState)response);
            }
        }
    }
}

