/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui.tree;

import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.ui.tree.Field;

public class Channel
extends MonitorChan {
    private boolean good;
    private boolean online;
    private boolean highLimitChanged;
    private boolean lowLimitChanged;
    private final String path;

    public Channel(String subsystemName, MonitorChan mc) {
        super(mc.getName(), mc.getDescription(), mc.getFormat(), mc.getUnits(), mc.getPage(), mc.getLowLimit(), mc.getLowWarning(), mc.getLowAlarm(), mc.getHighLimit(), mc.getHighWarning(), mc.getHighAlarm(), mc.getValue());
        this.path = subsystemName + "/" + mc.getName();
    }

    public Object get(Field field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case VALUE: {
                return this.getValue();
            }
            case UNITS: {
                return this.getUnits();
            }
            case LOW: {
                return this.getLowLimit();
            }
            case ALERT_LOW: {
                return this.getLowAlarm();
            }
            case HIGH: {
                return this.getHighLimit();
            }
            case ALERT_HIGH: {
                return this.getHighAlarm();
            }
            case DESCR: {
                return this.getDescription();
            }
        }
        return null;
    }

    public void set(Field field, Object value) {
        switch (field) {
            case VALUE: {
                this.setValue((Double)value);
                break;
            }
            case UNITS: {
                this.setUnits((String)value);
                break;
            }
            case LOW: {
                this.setLowLimit((Double)value);
                break;
            }
            case ALERT_LOW: {
                this.setLowAlarm((String)value);
                break;
            }
            case HIGH: {
                this.setHighLimit((Double)value);
                break;
            }
            case ALERT_HIGH: {
                this.setHighAlarm((String)value);
                break;
            }
            case NAME: {
                this.setName((String)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + (Object)((Object)field) + " cannot be modified.");
            }
        }
    }

    public boolean isGood() {
        return this.good;
    }

    public void setGood(boolean good) {
        this.good = good;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isHighLimitChanged() {
        return this.highLimitChanged;
    }

    public void setHighLimitChanged(boolean highLimitChanged) {
        this.highLimitChanged = highLimitChanged;
    }

    public boolean isLowLimitChanged() {
        return this.lowLimitChanged;
    }

    public void setLowLimitChanged(boolean lowLimitChanged) {
        this.lowLimitChanged = lowLimitChanged;
    }

    public String getPath() {
        return this.path;
    }

    public String getSubsystemName() {
        return this.path.substring(0, this.path.indexOf("/"));
    }
}

