/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.power.ui.PowerControlGui;

@Plugin(name="CCS Power Supply Plugin", description="CCS Power Supply Plugin")
public class PowerControlPlugin
extends ConsolePlugin {
    private final OptionalPage powerSupplyOptionalPage = new PowerSupplyControlOptionalPage();

    public void initialize() {
        Console.getConsole().addOptionalPage(this.powerSupplyOptionalPage);
    }

    static class PowerSupplyControlOptionalPage
    implements OptionalPage {
        PowerSupplyControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPath() {
            return "CCS Subsystems/Power Supply";
        }

        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty("powerSupplyType")) {
                String agentName = agent.getName();
                String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Control";
                return title;
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            PowerControlGui gui = new PowerControlGui(agentName);
            gui.initGui();
            return gui.getGuiLayout();
        }
    }
}

