/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;

public class ATSPowerControlPanel
extends JPanel {
    private static final Font FONT = new Font("Tahoma", 1, 12);
    private static final Color RED = new Color(180, 0, 0);
    private static final Color GREEN = new Color(0, 180, 0);
    private static final Color BLUE = new Color(0, 150, 180);
    private static final Color YELLOW = new Color(200, 180, 0);
    private static final Color GREY = Color.GRAY;
    private static final Map<Integer, String> chanNames = new HashMap<Integer, String>();
    private final CommandSender gui;
    private final JLabel lblPowerStateValue = new JLabel("....");
    private final JTextField tfPowerPeriod = new JTextField("...");
    private JButton btnPowerOn;
    private JButton btnPowerOff;
    private JButton btnBiasOn;
    private JButton btnBiasOff;
    private JTextField tfBiasVal = new JTextField();
    private JTextField tfDphiVal = new JTextField();
    private final JButton[] btnChanStatus = new JButton[8];
    private String powerName;
    private double powerPeriod = 5.0;
    private double hvBias;
    private double dphi;
    private static final long serialVersionUID = 1L;

    public ATSPowerControlPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        new UpdatePowerStatus(new ATSPowerState(0, new Boolean[8], 0.0, 0.0)).run();
        new DisableSystem().run();
    }

    public void setSubsystems(String powerName) {
        this.powerName = powerName;
    }

    private void initComponents() {
        Dimension ds = this.lblPowerStateValue.getPreferredSize();
        ds.width = 80;
        this.lblPowerStateValue.setPreferredSize(ds);
        this.lblPowerStateValue.setMinimumSize(ds);
        Dimension dp = this.tfPowerPeriod.getPreferredSize();
        dp.width = 50;
        this.tfPowerPeriod.setPreferredSize(dp);
        this.tfPowerPeriod.setMinimumSize(dp);
        this.tfPowerPeriod.setHorizontalAlignment(0);
        this.tfPowerPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.setUpdatePeriod();
            }
        });
        JButton btn = new JButton("On");
        btn.setForeground(GREEN);
        btn.setFocusable(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.gui.sendCommand(ATSPowerControlPanel.this.powerName, null, "powerOn", new Object[0]);
            }
        });
        this.btnPowerOn = btn;
        btn = new JButton("Off");
        btn.setForeground(RED);
        btn.setFocusable(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.gui.sendCommand(ATSPowerControlPanel.this.powerName, null, "powerOff", new Object[0]);
            }
        });
        this.btnPowerOff = btn;
        btn = new JButton("On");
        btn.setForeground(GREEN);
        btn.setFocusable(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.gui.sendCommand(ATSPowerControlPanel.this.powerName, null, "hvBiasOn", new Object[0]);
            }
        });
        this.btnBiasOn = btn;
        btn = new JButton("Off");
        btn.setForeground(RED);
        btn.setFocusable(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.gui.sendCommand(ATSPowerControlPanel.this.powerName, null, "hvBiasOff", new Object[0]);
            }
        });
        this.btnBiasOff = btn;
        JTextField tf = new JTextField("...");
        Dimension dd = tf.getPreferredSize();
        dd.width = 60;
        tf.setPreferredSize(dd);
        tf.setMinimumSize(dd);
        tf.setHorizontalAlignment(0);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.setBiasValue();
            }
        });
        this.tfBiasVal = tf;
        tf = new JTextField("...");
        tf.setPreferredSize(dd);
        tf.setMinimumSize(dd);
        tf.setHorizontalAlignment(0);
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATSPowerControlPanel.this.setDphiValue();
            }
        });
        this.tfDphiVal = tf;
        StringBuilder blanks = new StringBuilder();
        for (int j = 0; j < 6; ++j) {
            blanks.append('\u00a0');
        }
        for (int cs = 0; cs < this.btnChanStatus.length; ++cs) {
            btn = new JButton("   ");
            btn.setName(String.format("%02d", cs));
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                }
            });
            this.btnChanStatus[cs] = btn;
        }
        JPanel pnlPowerState = new JPanel();
        pnlPowerState.add(new JLabel("System State: "));
        pnlPowerState.add(this.lblPowerStateValue);
        JPanel pnlPowerPeriod = new JPanel();
        pnlPowerPeriod.add(new JLabel("Update Period: "));
        pnlPowerPeriod.add(this.tfPowerPeriod);
        pnlPowerPeriod.add(new JLabel("sec"));
        JPanel pnlPowerControl = new JPanel();
        pnlPowerControl.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 6, 4, 6);
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        pnlPowerControl.add((Component)new JLabel("Seq. Power"), gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        pnlPowerControl.add((Component)this.btnPowerOn, gbp);
        ++gbp.gridx;
        pnlPowerControl.add((Component)this.btnPowerOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        pnlPowerControl.add((Component)new JLabel("HV Bias"), gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        pnlPowerControl.add((Component)this.btnBiasOn, gbp);
        ++gbp.gridx;
        pnlPowerControl.add((Component)this.btnBiasOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        pnlPowerControl.add((Component)new JLabel("Bias Volts"), gbp);
        gbp.gridy = 1;
        pnlPowerControl.add((Component)this.tfBiasVal, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        pnlPowerControl.add((Component)new JLabel("DPHI Volts"), gbp);
        gbp.gridy = 1;
        pnlPowerControl.add((Component)this.tfDphiVal, gbp);
        JPanel pnlChanStatus = new JPanel();
        pnlChanStatus.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.insets = new Insets(4, 6, 4, 6);
        gbs.gridx = 0;
        for (int j = 0; j < this.btnChanStatus.length; ++j) {
            gbs.gridy = 0;
            pnlChanStatus.add((Component)new JLabel(chanNames.get(j)), gbs);
            gbs.gridy = 1;
            pnlChanStatus.add((Component)this.btnChanStatus[j], gbs);
            ++gbs.gridx;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 10, 6, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)pnlPowerState, gbc);
        ++gbc.gridx;
        this.add((Component)pnlPowerPeriod, gbc);
        gbc.insets = new Insets(6, 6, 6, 6);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.add((Component)pnlPowerControl, gbc);
        ++gbc.gridy;
        this.add((Component)pnlChanStatus, gbc);
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.tfPowerPeriod.getText());
            this.gui.sendCommand(this.powerName, null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
        }
        catch (NumberFormatException nfe) {
            this.tfPowerPeriod.setText(String.valueOf(this.powerPeriod));
        }
    }

    private void setBiasValue() {
        try {
            double value = Double.valueOf(this.tfBiasVal.getText());
            this.gui.sendCommand(this.powerName, null, "setHvBias", new Object[]{value});
        }
        catch (NumberFormatException nfe) {
            this.tfBiasVal.setText(String.format("%.1f", this.hvBias));
        }
    }

    private void setDphiValue() {
        try {
            double value = Double.valueOf(this.tfDphiVal.getText());
            this.gui.sendCommand(this.powerName, null, "setDphi", new Object[]{value});
        }
        catch (NumberFormatException nfe) {
            this.tfDphiVal.setText(String.format("%.1f", this.dphi));
        }
    }

    public void updateControlPanel(int id, ATSPowerState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disableSystem(int id) {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        chanNames.put(0, "Dig");
        chanNames.put(1, "Ana");
        chanNames.put(2, "ClkH");
        chanNames.put(3, "ClkL");
        chanNames.put(4, "OD");
        chanNames.put(5, "Htr");
        chanNames.put(6, "DPHI");
        chanNames.put(7, "HVbias");
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            ATSPowerControlPanel.this.lblPowerStateValue.setText("STOPPED");
            ATSPowerControlPanel.this.lblPowerStateValue.setForeground(RED);
            ATSPowerControlPanel.this.tfPowerPeriod.setEnabled(false);
            ATSPowerControlPanel.this.btnPowerOn.setEnabled(false);
            ATSPowerControlPanel.this.btnPowerOff.setEnabled(false);
            ATSPowerControlPanel.this.btnBiasOn.setEnabled(false);
            ATSPowerControlPanel.this.btnBiasOff.setEnabled(false);
            ATSPowerControlPanel.this.tfBiasVal.setEnabled(false);
            ATSPowerControlPanel.this.tfDphiVal.setEnabled(false);
            for (JButton btn : ATSPowerControlPanel.this.btnChanStatus) {
                btn.setBackground(GREY);
                btn.setEnabled(false);
            }
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final ATSPowerState rs;

        UpdatePowerStatus(ATSPowerState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ATSPowerControlPanel.this.lblPowerStateValue.setText("RUNNING");
            ATSPowerControlPanel.this.lblPowerStateValue.setForeground(GREEN);
            ATSPowerControlPanel.this.powerPeriod = (double)this.rs.getTickMillis() / 1000.0;
            ATSPowerControlPanel.this.tfPowerPeriod.setText(String.valueOf(ATSPowerControlPanel.this.powerPeriod));
            ATSPowerControlPanel.this.tfPowerPeriod.setEnabled(true);
            ATSPowerControlPanel.this.btnPowerOn.setEnabled(true);
            ATSPowerControlPanel.this.btnPowerOff.setEnabled(true);
            ATSPowerControlPanel.this.btnBiasOn.setEnabled(true);
            ATSPowerControlPanel.this.btnBiasOff.setEnabled(true);
            ATSPowerControlPanel.this.hvBias = this.rs.getHvBias();
            ATSPowerControlPanel.this.tfBiasVal.setText(String.valueOf(ATSPowerControlPanel.this.hvBias));
            ATSPowerControlPanel.this.tfBiasVal.setEnabled(true);
            ATSPowerControlPanel.this.dphi = this.rs.getDphi();
            ATSPowerControlPanel.this.tfDphiVal.setText(String.valueOf(ATSPowerControlPanel.this.dphi));
            ATSPowerControlPanel.this.tfDphiVal.setEnabled(true);
            Boolean[] state = this.rs.getPowerState();
            for (int j = 0; j < ATSPowerControlPanel.this.btnChanStatus.length; ++j) {
                ATSPowerControlPanel.this.btnChanStatus[j].setBackground(state[j] == null ? BLUE : (state[j] != false ? GREEN : RED));
                ATSPowerControlPanel.this.btnChanStatus[j].setEnabled(true);
            }
        }
    }
}

