/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.power.data.ATSPowerFullState;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;
import org.lsst.ccs.subsystem.power.ui.ATSPowerControlGui;
import org.lsst.ccs.subsystem.power.ui.ATSPowerControlPanel;

public class ATSPowerControlAssembly
extends MonitorGui.Panel {
    MonitorAssembly mon;
    ATSPowerControlPanel panel;
    private static final long serialVersionUID = 1L;

    public ATSPowerControlAssembly(ATSPowerControlGui gui) {
        this.setLayout(new BorderLayout());
        this.mon = new MonitorAssembly((CommandSender)gui);
        this.add((Component)this.mon, "Center");
        this.panel = new ATSPowerControlPanel((CommandSender)gui);
        this.add(this.panel, "South");
    }

    public void setSubsystems(String ... names) {
        this.mon.setSubsystems(names);
        this.panel.setSubsystems(names[0]);
    }

    public void disableSystem(String name, int id) {
        this.panel.disableSystem(id);
        this.mon.disableSystem(name);
    }

    public void updatePanel(String name, int id, Object d) {
        if (d instanceof ATSPowerFullState) {
            ATSPowerFullState r = (ATSPowerFullState)d;
            this.mon.updateTableModel(name, r.getMonitorFullState());
            this.panel.updateControlPanel(id, r.getATSPowerState());
        }
    }

    public void handleStatusData(String name, int id, long time, String key, Object d) {
        if (key.equals("ATSPowerState")) {
            this.panel.updateControlPanel(id, (ATSPowerState)((KeyValueData)d).getValue());
        } else {
            this.mon.handleData(name, key, d);
        }
    }
}

