package org.lsst.ccs.subsystem.power.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.power.data.ATSPowerFullState;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;

/**
 *  Implements the ATS power control panel / monitor panel assembly.
 *
 *  @author Owen Saxton
 */
public class ATSPowerControlAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    ATSPowerControlPanel panel;
    
    public ATSPowerControlAssembly(ATSPowerControlGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new ATSPowerControlPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystems(String... names) {
        mon.setSubsystems(names);
        panel.setSubsystems(names[0]);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof ATSPowerFullState) {
            ATSPowerFullState r = (ATSPowerFullState)d;
            mon.updateTableModel(name, r.getMonitorFullState());
            panel.updateControlPanel(id, r.getATSPowerState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(ATSPowerState.KEY)) {
            panel.updateControlPanel(id, (ATSPowerState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
