package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.subsystem.power.data.PowerSupplyAgentProperties;
import org.lsst.ccs.subsystem.power.ui.RebPsControlGui;

/**
 *
 * @author tonyj
 */
@Plugin(name = "CCS Reb Power Supply Plugin", description = "CCS Reb Power Supply Plugin")
public class RebPsControlPlugin extends ConsolePlugin {

    private final OptionalPage rebPsOptionalPage = new RebPsControlPlugin.RebPsControlOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().addOptionalPage(rebPsOptionalPage);
    }

    static class RebPsControlOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPath() {
            return "CCS Subsystems/obsolete/Reb PS";
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.hasAgentProperty(PowerSupplyAgentProperties.REB_POWER_SUPPLY_TYPE_AGENT_PROPERTY)) {
                String agentName = agent.getName();
                String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Control";
                return title;
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String agentName = agent.getName();
            RebPsControlGui gui = new RebPsControlGui(agentName);
            gui.initGui();
            return gui.getGuiLayout();
        }

    }


}
