/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.power.data.RebPsFullState;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.subsystem.power.ui.RebPsControlPanel;
import org.lsst.ccs.subsystem.power.ui.jas.RebPsMonitorFilter;

@Plugin(name="CCS Reb Power Supply Plugin New", description="CCS Reb Power Supply Plugin New")
public class RebPsControlPluginNew
extends ConsolePlugin {
    private OptionalPage rebPsOptionalPage;

    public void initialize() {
        this.rebPsOptionalPage = new RebPsControlOptionalPage(Console.getConsole());
        Console.getConsole().addOptionalPage(this.rebPsOptionalPage);
    }

    static class PrivateCommandSender
    implements CommandSender {
        private final Console console;

        PrivateCommandSender(Console console) {
            this.console = console;
        }

        public Object sendCommand(String dest, String target, String cmnd, Object ... args) {
            try {
                return this.sendCommandRaw(dest, target, cmnd, args);
            }
            catch (Exception e) {
                this.console.getLoggerUI().error((Object)"Command error: ", (Throwable)e);
                return null;
            }
        }

        public Object sendCommandRaw(String dest, String target, String cmnd, Object ... args) throws Exception {
            String dst = dest + (target == null ? "" : "/" + target);
            dst = dst + "/" + cmnd;
            return this.console.sendCommand(Duration.ofSeconds(1L), dst, args);
        }
    }

    static class BusListener
    implements AgentPresenceListener,
    StatusMessageListener {
        private final RebPsControlPanel controls;
        private final String agentName;
        private final CommandSender cmdSender;

        BusListener(RebPsControlPanel controls, String agentName, CommandSender cmdSender) {
            this.controls = controls;
            this.agentName = agentName;
            this.cmdSender = cmdSender;
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg.getOriginAgentInfo().getName().equals(this.agentName) && msg instanceof StatusSubsystemData) {
                try {
                    StatusSubsystemData sd = (StatusSubsystemData)msg;
                    if (sd.getDataKey().equals("RebPsState")) {
                        this.controls.updateControlPanel(0, (RebPsState)sd.getSubsystemData().getValue());
                    }
                }
                catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                    // empty catch block
                }
            }
        }

        public void disconnecting(AgentInfo agent) {
            if (agent.getName().equals(this.agentName)) {
                this.controls.disableSystem(0);
            }
        }

        public void connecting(AgentInfo agent) {
            Object response;
            if (agent.getName().equals(this.agentName) && (response = this.cmdSender.sendCommand(this.agentName, null, "getFullState", new Object[0])) instanceof RebPsFullState) {
                RebPsFullState r = (RebPsFullState)response;
                this.controls.updateControlPanel(0, r.getRebPsState());
            }
        }
    }

    static class RebPsControlOptionalPage
    implements OptionalPage {
        private final PrivateCommandSender cmdSender;
        private final Map<String, BusListener> busListeners = new ConcurrentHashMap<String, BusListener>();

        RebPsControlOptionalPage(Console console) {
            this.cmdSender = new PrivateCommandSender(Console.getConsole());
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPath() {
            return "CCS Subsystems/Reb PS";
        }

        public String getPage(AgentInfo agent) {
            return this.getPageNameForAgent(agent);
        }

        private String getPageNameForAgent(AgentInfo agent) {
            String pageName = null;
            if (agent.hasAgentProperty("rebPowerSupplyType")) {
                String title;
                String agentName = agent.getName();
                pageName = title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Control";
            }
            return pageName;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            RebPsMonitorFilter monitorFilter = new RebPsMonitorFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            panel.add((Component)view.getPanel(), "Center");
            RebPsControlPanel controls = new RebPsControlPanel(this.cmdSender);
            controls.setSubsystems(agent.getName());
            String pageName = this.getPageNameForAgent(agent);
            if (this.busListeners.containsKey(pageName)) {
                throw new RuntimeException("Page with name " + pageName + " already exists for the Reb Ps plugin.");
            }
            BusListener busListener = new BusListener(controls, agent.getName(), this.cmdSender);
            Console.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)busListener);
            Console.getConsole().getMessagingAccess().addStatusMessageListener((StatusMessageListener)busListener);
            this.busListeners.put(pageName, busListener);
            panel.add((Component)controls, "South");
            return panel;
        }

        public void closed(String page) {
            BusListener busListener = this.busListeners.remove(page);
            if (busListener != null) {
                Console.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)busListener);
                Console.getConsole().getMessagingAccess().addStatusMessageListener((StatusMessageListener)busListener);
            }
        }
    }
}

