package org.lsst.ccs.subsystem.power.ui.jas;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.power.data.PowerSupplyAgentProperties;
import org.lsst.ccs.subsystem.power.ui.RebPsControlGui;

/**
 *
 * @author tonyj
 */
@Plugin(name = "CCS Reb Power Supply Plugin", description = "CCS Reb Power Supply Plugin")
public class RebPsControlPlugin extends ConsolePlugin {

    //TO-DO: we have to remove the guis from the maps when their windows are
    //closed in the JAS console.
    private final Map<String, RebPsControlGui> mapOfPowerSupplyGuis = new HashMap<>();
    private final Object guiCreationLock = new Object();

    @Override
    public void initialize() {

        //Listen for the presence of subsystems before opening the windows
        getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(
                new AgentPresenceListener() {

                    @Override
                    public void connecting(AgentInfo agent) {
                        if (agent.hasAgentProperty(PowerSupplyAgentProperties.REB_POWER_SUPPLY_TYPE_AGENT_PROPERTY)) {
                            String automaticallyLoadAgent = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.ui.agents.load.on.connecting", "");
                            if (automaticallyLoadAgent.isEmpty() || Arrays.asList(automaticallyLoadAgent.split(",")).contains(agent.getName())) {
                                synchronized (guiCreationLock) {
                                    if (mapOfPowerSupplyGuis.get(agent.getName()) == null) {
                                        mapOfPowerSupplyGuis.put(agent.getName(), openPowerSupplyGui(agent.getName(), getConsole()));
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public void disconnecting(AgentInfo agent) {

                    }
                }
        );

    }

    private static RebPsControlGui openPowerSupplyGui(String agentName, Console console) {
        RebPsControlGui gui = new RebPsControlGui(agentName);
        String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Control";
        ((Jas3Console) console).getApplication().getPageManager().openPage(gui.getGuiLayout(), title, null);
        gui.initGui();
        return gui;
    }

}
