/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.dao;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.BaseState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.utilities.logging.Logger;

public class LocaldbFacade {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");

    private LocaldbFacade() {
    }

    public static AgentDesc getAgentDesc(AgentInfo agentInfo, Session sess) {
        String key = agentInfo.getName();
        AgentDesc ad = (AgentDesc)sess.get(AgentDesc.class, (Serializable)((Object)key));
        if (ad == null) {
            ad = new AgentDesc(agentInfo);
            sess.persist((Object)ad);
            log.debug((Object)("Added Agent description for " + key + " : " + ad.getAgentName()));
        }
        return ad;
    }

    public static AlertDesc getAlertDescOrPersist(AgentDesc agentDesc, Alert alert, Session sess) {
        AlertDesc ad = LocaldbFacade.getAlertDesc(agentDesc, alert.getAlertId(), sess);
        if (ad == null) {
            ad = new AlertDesc();
            ad.setAgentDesc(agentDesc);
            ad.setAlertId(alert.getAlertId());
            ad.setAlertDescription(alert.getDescription());
            sess.persist((Object)ad);
            log.debug((Object)("Added Alert description for " + agentDesc.getAgentName() + "/" + alert.getAlertId() + " : " + ad.getAlertId()));
        }
        return ad;
    }

    public static AlertDesc getAlertDesc(AgentDesc agentDesc, String alertId, Session sess) {
        Query q = sess.getNamedQuery("findAlertDesc");
        q.setString("id", alertId).setString("name", agentDesc.getAgentName());
        return (AlertDesc)q.uniqueResult();
    }

    private static InnerStateDesc getInnerStateDesc(AgentDesc ad, String enumClassName, String enumValue, Session sess) {
        Query q = sess.getNamedQuery("findInnerStateDesc");
        q.setEntity("agentDesc", (Object)ad).setString("enumClassName", enumClassName).setString("enumValue", enumValue);
        InnerStateDesc isd = (InnerStateDesc)q.uniqueResult();
        if (isd == null) {
            isd = new InnerStateDesc(ad);
            isd.setEnumClassName(enumClassName);
            isd.setEnumValue(enumValue);
            sess.persist((Object)isd);
            log.debug((Object)("Added Inner State description description for " + isd.toString()));
        }
        return isd;
    }

    private static StateBundleDesc getStateBundleDesc(AgentDesc ad, StateBundle sb, List<StateBundleDesc> existingSBDs, Session sess) {
        HashMap<String, InnerStateDesc> componentStates = new HashMap<String, InnerStateDesc>();
        HashMap allStates = new HashMap(sb.getAllStatesAsStrings());
        allStates.remove("PhaseState");
        allStates.remove("OperationalState");
        allStates.remove("ConfigurationState");
        allStates.remove("CommandState");
        allStates.remove("AlertState");
        for (Map.Entry state : allStates.entrySet()) {
            componentStates.put((String)state.getKey(), LocaldbFacade.getInnerStateDesc(ad, (String)state.getKey(), (String)state.getValue(), sess));
        }
        for (StateBundleDesc sdb : existingSBDs) {
            if (!sdb.getComponentStates().equals(componentStates)) continue;
            return sdb;
        }
        StateBundleDesc sdb = new StateBundleDesc(ad);
        sdb.setComponentStates(componentStates);
        sess.persist((Object)sdb);
        return sdb;
    }

    private static BaseState getBaseState(StateBundle sb, Session sess) {
        BaseState bs = new BaseState(sb);
        Query q = sess.getNamedQuery("findBaseState").setString("alertSt", bs.getAlertState()).setString("phaseSt", bs.getPhaseState()).setString("commandSt", bs.getCommandState()).setString("operationalSt", bs.getOperationalState()).setString("configurationSt", bs.getConfigState());
        log.debug((Object)("sending query : " + q.getQueryString()));
        BaseState persistedBS = (BaseState)q.uniqueResult();
        if (persistedBS == null) {
            sess.persist((Object)bs);
            log.debug((Object)("Added BaseState description for " + bs.toString()));
            return bs;
        }
        return persistedBS;
    }

    public static AgentState getAgentState(AgentDesc ad, StateBundle sb, Session sess) {
        BaseState bs = LocaldbFacade.getBaseState(sb, sess);
        HashMap internalStates = new HashMap(sb.getAllStatesAsStrings());
        internalStates.remove("PhaseState");
        internalStates.remove("OperationalState");
        internalStates.remove("ConfigurationState");
        internalStates.remove("CommandState");
        internalStates.remove("AlertState");
        HashMap internalStateDescs = new HashMap();
        for (Map.Entry entry : internalStates.entrySet()) {
            internalStateDescs.put(entry.getKey(), LocaldbFacade.getInnerStateDesc(ad, (String)entry.getKey(), (String)entry.getValue(), sess));
        }
        Query q = sess.createQuery("from StateBundleDesc sbd where sbd.agentDesc=:ad").setEntity("ad", (Object)ad);
        List list = q.list();
        HashMap<String, StateBundleDesc> componentStateBundles = new HashMap<String, StateBundleDesc>();
        for (String comp : sb.getComponentsWithStates()) {
            StateBundle csb = sb.getComponentStateBundle(comp);
            StateBundleDesc sbd = LocaldbFacade.getStateBundleDesc(ad, csb, list, sess);
            componentStateBundles.put(comp, sbd);
        }
        Query asq = sess.getNamedQuery("findAgentState").setEntity("agentDesc", (Object)ad).setLong("baseStateId", bs.getId());
        List possibleStates = asq.list();
        AgentState as = null;
        HashMap<String, StateBundleDesc> componentStateBundlesWithTop = new HashMap<String, StateBundleDesc>(componentStateBundles);
        componentStateBundlesWithTop.put("", LocaldbFacade.getStateBundleDesc(ad, sb, list, sess));
        for (AgentState a : possibleStates) {
            if (!a.getComponentStates().equals(componentStateBundlesWithTop)) continue;
            as = a;
            break;
        }
        if (as == null && componentStateBundles.isEmpty()) {
            for (AgentState a : possibleStates) {
                if (!a.getInnerStates().equals(internalStateDescs)) continue;
                if (!a.getInnerStates().isEmpty()) {
                    log.warn((Object)"some agent states are persisted with a deprecated schema : run the migration application \"MigrateAgentStates\"");
                }
                as = a;
                break;
            }
        }
        if (as == null) {
            as = new AgentState(ad);
            as.setBaseState(bs);
            as.setComponentStates(componentStateBundlesWithTop);
            sess.persist((Object)as);
            log.debug((Object)("Added AgentState for " + as.toString()));
        }
        return as;
    }

    public static StatTimeInterval getStatTimeInterval(long binWidth, long dataTime, Session sess) {
        Query statTimeIntervalQuery = sess.getNamedQuery("findStatTimeInterval").setFlushMode(FlushMode.COMMIT).setCacheable(true);
        long statTimeIntervalStart = dataTime / binWidth * binWidth;
        statTimeIntervalQuery.setLong("binWidth", binWidth);
        statTimeIntervalQuery.setLong("t1", statTimeIntervalStart);
        StatTimeInterval statTimeInterval = (StatTimeInterval)statTimeIntervalQuery.uniqueResult();
        if (statTimeInterval == null) {
            statTimeInterval = new StatTimeInterval(statTimeIntervalStart, binWidth);
            sess.persist((Object)statTimeInterval);
        }
        return statTimeInterval;
    }
}

