/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.PeriodicTaskComponent;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public final class AgentPeriodicTaskService
implements HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    private final Scheduler scheduler;
    private final ConcurrentHashMap<String, PeriodicTaskComponent> tasksMap = new ConcurrentHashMap();
    private final Object taskLock = new Object();
    private boolean hasBeenInitialized = false;
    private final ComponentLookup lookupService;
    private final ComponentNode agentPeriodicTaskNode;
    private final Agent agent;

    public AgentPeriodicTaskService(Agent a) {
        this.scheduler = new Scheduler("AgentPeriodicTaskService scheduler for " + a.getName(), 5);
        this.scheduler.setLogger(a.getLogger());
        this.lookupService = a.getComponentLookup();
        this.agentPeriodicTaskNode = new ComponentNode(this.lookupService.getTopComponentNode(), "periodicTasks", (Object)this);
        this.lookupService.addComponentNodeToLookup(null, this.agentPeriodicTaskNode);
        this.agent = a;
    }

    @Override
    public void init() {
        this.hasBeenInitialized = true;
    }

    @Override
    public void postStop() {
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            log.severe((Object)"could not await scheduler termination", (Throwable)ex);
            this.scheduler.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAgentPeriodicTask(AgentPeriodicTask task) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to schedule an AgentPeriodicTask. Tasks must be scheduled in the init phase of HasLifecycle.");
        }
        Object object = this.taskLock;
        synchronized (object) {
            if (this.tasksMap.containsKey(task.getTaskName())) {
                throw new RuntimeException("Task with name " + task.getTaskName() + " has already been scheduled. Tasks must be unique.");
            }
            PeriodicTaskComponent periodicTaskComponent = new PeriodicTaskComponent(task, this.scheduler);
            this.tasksMap.put(task.getTaskName(), periodicTaskComponent);
            ComponentNode taskNode = new ComponentNode(this.agentPeriodicTaskNode, task.getTaskName(), (Object)periodicTaskComponent);
            this.lookupService.addComponentNodeToLookup(this.agentPeriodicTaskNode.getKey(), taskNode);
        }
    }

    public Duration getPeriodicTaskPeriod(String taskName) {
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        return Duration.ofMillis(periodicTask.getTaskPeriodMillis());
    }

    public void setPeriodicTaskPeriod(String taskName, Duration period) {
        Subsystem s;
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        if (this.agent instanceof Subsystem && (s = (Subsystem)this.agent).getConfigurationService() != null && s.getState().getState(ConfigurationState.class) != null && !s.isInState((Enum)ConfigurationState.INITIAL_SAFE)) {
            s.getConfigurationService().change(taskName, "taskPeriodMillis", period.toMillis());
            return;
        }
        periodicTask.setTaskPeriodMillis(period.toMillis());
    }

    @Command(name="getAgentPeriodicTaskNames", description="Get the list of the names of the scheduled tasks", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public List<String> getAgentPeriodicTaskNames() {
        return Collections.list(this.tasksMap.keys());
    }
}

