/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.power.data.PowerSupplyAgentProperties;
import org.lsst.ccs.subsystem.power.ui.RebPsControlGui;

@Plugin(name="CCS Reb Power Supply Plugin", description="CCS Reb Power Supply Plugin")
public class RebPsControlPlugin
extends ConsolePlugin {
    private final Map<String, RebPsControlGui> mapOfPowerSupplyGuis = new HashMap<String, RebPsControlGui>();
    private final Object guiCreationLock = new Object();

    public void initialize() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connecting(AgentInfo agent) {
                String automaticallyLoadAgent;
                if (agent.hasAgentProperty(PowerSupplyAgentProperties.POWER_SUPPLY_TYPE_AGENT_PROPERTY) && ((automaticallyLoadAgent = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.ui.agents.load.on.connecting", "")).isEmpty() || Arrays.asList(automaticallyLoadAgent.split(",")).contains(agent.getName()))) {
                    Object object = RebPsControlPlugin.this.guiCreationLock;
                    synchronized (object) {
                        if (RebPsControlPlugin.this.mapOfPowerSupplyGuis.get(agent.getName()) == null) {
                            RebPsControlPlugin.this.mapOfPowerSupplyGuis.put(agent.getName(), RebPsControlPlugin.openPowerSupplyGui(agent.getName(), RebPsControlPlugin.this.getConsole()));
                        }
                    }
                }
            }

            public void disconnecting(AgentInfo agent) {
            }
        });
    }

    private static RebPsControlGui openPowerSupplyGui(String agentName, Console console) {
        RebPsControlGui gui = new RebPsControlGui(agentName);
        String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " PS Controls";
        ((Jas3Console)console).getApplication().getPageManager().openPage((Component)gui.getGuiLayout(), title, null);
        gui.initGui();
        return gui;
    }
}

