/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerBuilder;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigurationHandlerSet {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private String descriptionName;
    private final Map<String, ConfigurationHandler> componentParameterHandlers = new LinkedHashMap<String, ConfigurationHandler>();
    private final Map<String, CategoryHandler> parametersByCategories = new HashMap<String, CategoryHandler>();
    private ConfigurationProxy configurationProxy;
    boolean isSafe = true;
    private ConfigurationInfo currentConfigInfo;

    ConfigurationHandlerSet() {
    }

    void addConfigurationHandlerForObject(String componentName, Object component) {
        ConfigurationHandler handler = ConfigurationHandlerBuilder.buildParameterSetterFromObject(componentName, component);
        if (handler == null) {
            return;
        }
        this.componentParameterHandlers.put(componentName, handler);
        for (ConfigurationParameterHandler cph : handler.getConfigurationParameterHandlers()) {
            String category = cph.getCategory();
            CategoryHandler set = this.parametersByCategories.get(category);
            if (set == null) {
                set = new CategoryHandler(category);
                this.parametersByCategories.put(category, set);
            }
            set.addParameterHandler(cph);
        }
    }

    void setRemoteConfigurationProxy() {
    }

    boolean isEmpty() {
        return this.componentParameterHandlers.isEmpty();
    }

    void initialize(String descriptionName, Map<Object, Object> safeConfigFromTopNode) {
        this.descriptionName = descriptionName;
        this.configurationProxy = new LocalConfigurationProxy(descriptionName);
        HashMap<String, String> safeConfig = new HashMap<String, String>();
        for (String string : this.getCategorySet()) {
            safeConfig.put(string, "safe");
        }
        HashMap<String, Properties> safeValues = new HashMap<String, Properties>();
        for (Map.Entry<Object, Object> entry : safeConfigFromTopNode.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            try {
                String string = TypeUtils.stringify((Object)entry.getValue());
                ParameterPath path = ParameterPath.valueOf((String)((String)entry.getKey()));
                if (!this.isParameterConfigurable(path.getComponentName(), path.getParameterName())) continue;
                Properties props = (Properties)safeValues.get(path.getComponentName());
                if (props == null) {
                    props = new Properties();
                    safeValues.put(path.getComponentName(), props);
                }
                props.put(path.getParameterName(), string);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Map<String, Properties> map = this.configurationProxy.loadCategories(safeConfig);
        for (Map.Entry<String, Properties> entry : map.entrySet()) {
            Properties props = (Properties)safeValues.get(entry.getKey());
            if (props == null) {
                props = new Properties();
                safeValues.put(entry.getKey(), props);
            }
            props.putAll((Map<?, ?>)entry.getValue());
        }
        try {
            this.doLoadParameters(safeValues, safeConfig);
            for (ConfigurationHandler configurationHandler : this.componentParameterHandlers.values()) {
                for (ConfigurationParameterHandler cph : configurationHandler.getConfigurationParameterHandlers()) {
                    cph.setInitialValue();
                }
            }
            this.isSafe = false;
        }
        catch (Exception exception) {
            throw new RuntimeException("could not load safe configuration", exception);
        }
    }

    ConfigurationProxy getConfigurationProxy() {
        return this.configurationProxy;
    }

    private ConfigurationHandler getParameterSet(String componentName) {
        ConfigurationHandler res = this.componentParameterHandlers.get(componentName);
        if (res == null) {
            throw new IllegalArgumentException("no such component : " + componentName);
        }
        return res;
    }

    private CategoryHandler getCategoryHandler(String category) {
        CategoryHandler res = this.parametersByCategories.get(category);
        if (res == null) {
            log.info((Object)("no such category : " + category));
        }
        return res;
    }

    public Set<String> getComponents() {
        return Collections.unmodifiableSet(this.componentParameterHandlers.keySet());
    }

    public boolean isParameterConfigurable(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterConfigurable(parameterName);
    }

    public Map<String, String> getTaggedCategoriesForCats(Set<String> categories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String category : categories) {
            res.put(category, this.parametersByCategories.get(category).getTag());
        }
        return res;
    }

    private ConfigurationInfo buildConfigurationInfo(ConfigurationInfo before) {
        HashMap<String, String> tags = new HashMap<String, String>();
        HashMap<String, Boolean> hasCatChanges = new HashMap<String, Boolean>();
        ArrayList<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();
        ArrayList<String> recentChanges = new ArrayList<String>();
        ConfigurationState realState = ConfigurationState.CONFIGURED;
        for (CategoryHandler ch : this.parametersByCategories.values()) {
            String category = ch.getCategory();
            tags.put(category, ch.getTag());
            boolean dirty = ch.isDirty();
            if (dirty) {
                realState = ConfigurationState.DIRTY;
            }
            hasCatChanges.put(category, dirty);
            for (ConfigurationParameterInfo cpi : ch.getConfigurationParameterInfo()) {
                parametersView.add(cpi);
                if (before == null || cpi.getCurrentValue().equals(before.getCurrentValueForParameter(cpi.getPathName()))) continue;
                recentChanges.add(cpi.getPathName());
            }
        }
        return new ConfigurationInfo(this.isSafe ? ConfigurationState.INITIAL_SAFE : realState, this.descriptionName, tags, hasCatChanges, parametersView, recentChanges);
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.parametersByCategories.keySet());
    }

    public void saveChangesForCategories(Map<String, String> taggedCategories) throws ConfigurationServiceException {
        HashMap<String, String> toSave = new HashMap<String, String>();
        ArrayList<ConfigurationParameterInfo> list = new ArrayList<ConfigurationParameterInfo>();
        for (Map.Entry<String, String> entry : taggedCategories.entrySet()) {
            String category = entry.getKey();
            String tag = entry.getValue();
            CategoryHandler ch = this.parametersByCategories.get(category);
            toSave.put(category, tag);
            list.addAll(ch.getConfigurationParameterInfo());
        }
        this.configurationProxy.saveChangesForCategoriesAs(toSave, list);
        for (Map.Entry<String, String> entry : toSave.entrySet()) {
            this.parametersByCategories.get(entry.getKey()).setRunningConfiguration(entry.getValue());
        }
        this.currentConfigInfo = this.buildConfigurationInfo(null);
    }

    public void loadCategories(Map<String, String> taggedCategories) {
        Map<String, Properties> changes = this.configurationProxy.loadCategories(taggedCategories);
        this.doLoadParameters(changes, taggedCategories);
    }

    private void doLoadParameters(Map<String, Properties> changes, Map<String, String> taggedCategories) {
        this.dropAllSubmittedChanges();
        for (Map.Entry<String, Properties> changesForComponent : changes.entrySet()) {
            String comp = changesForComponent.getKey();
            ConfigurationHandler ch = this.componentParameterHandlers.get(comp);
            Properties props = changesForComponent.getValue();
            for (String parm : props.stringPropertyNames()) {
                if (this.isParameterConfigurable(comp, parm)) {
                    ch.submitChange(parm, props.getProperty(parm));
                    continue;
                }
                log.info((Object)("ignoring : " + new ParameterPath(comp, parm)));
            }
        }
        for (String category : taggedCategories.keySet()) {
            CategoryHandler ch = this.getCategoryHandler(category);
            for (ConfigurationParameterHandler cph : ch.getParameters()) {
                String componentName = cph.getComponentName();
                String parameterName = cph.getParameterName();
                if (changes.containsKey(componentName) && changes.get(componentName).containsKey(parameterName)) continue;
                this.submitChange(componentName, parameterName, cph.getInitialValue());
            }
        }
        this.commitBulkChange(taggedCategories);
    }

    public void dropChangesForCategories(Set<String> categories) {
        this.dropAllSubmittedChanges();
        for (String category : categories) {
            CategoryHandler ch = this.parametersByCategories.get(category);
            for (ConfigurationParameterHandler cph : ch.getParameters()) {
                if (!cph.isDirty()) continue;
                this.getParameterSet(cph.getComponentName()).submitChange(cph.getParameterName(), cph.getConfiguredValue());
            }
        }
        this.commitBulkChange(this.getTaggedCategoriesForCats(categories));
    }

    public void dropAllSubmittedChanges() {
        this.componentParameterHandlers.values().stream().forEach(ConfigurationHandler::dropSubmittedChanges);
    }

    public void dropSubmittedChangesForComponent(String name) {
        this.getParameterSet(name).dropSubmittedChanges();
    }

    public Map<String, String> getSubmittedChangesForComponent(String name) {
        return this.getParameterSet(name).getSubmittedChanges().entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> (String)entry.getValue()));
    }

    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        TreeMap<String, Map<String, String>> res = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            Map<String, String> submittedChanges = this.getSubmittedChangesForComponent(entry.getKey());
            if (submittedChanges.isEmpty()) continue;
            res.put(entry.getKey(), new TreeMap<String, String>(submittedChanges));
        }
        return res;
    }

    public void submitChange(String componentName, String parameterName, Object value) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter : " + componentName + "//" + parameterName + " : ignored"));
        } else {
            this.getParameterSet(componentName).submitChange(parameterName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitBulkChange(Map<String, String> categoriesToCommit) {
        HashMap<ParameterPath, String> submittedChanges;
        ConfigurationInfo before;
        block15: {
            before = this.buildConfigurationInfo(null);
            submittedChanges = new HashMap<ParameterPath, String>();
            for (ConfigurationHandler configurationHandler : this.componentParameterHandlers.values()) {
                configurationHandler.trimSubmittedChanges();
                submittedChanges.putAll(configurationHandler.getSubmittedChanges());
            }
            log.fine((Object)("processing the following submitted changes :" + submittedChanges));
            BulkValidationException excThrown = null;
            try {
                for (ConfigurationHandler configurationHandler : this.componentParameterHandlers.values()) {
                    configurationHandler.invokeValidateBulkChange(this.isSafe);
                }
            }
            catch (Exception exception) {
                excThrown = new BulkValidationException(exception);
            }
            finally {
                ConfigurationInfo configurationInfo = this.buildConfigurationInfo(before);
                if (!configurationInfo.getLatestChanges().isEmpty()) {
                    this.dropAllSubmittedChanges();
                    Set set = configurationInfo.getLatestChanges().stream().map(ConfigurationParameterInfo::getPathName).collect(Collectors.toSet());
                    this.currentConfigInfo = configurationInfo;
                    throw new BulkSettingException("some parameters have been modified during the validation step : " + set, excThrown);
                }
                if (excThrown == null) break block15;
                throw excThrown;
            }
        }
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            ConfigurationHandler configurationHandler = entry.getValue();
            try {
                configurationHandler.invokeSetParameters(before.getCurrentValuesFor(entry.getKey()));
            }
            catch (Exception ex) {
                ConfigurationInfo ci = this.buildConfigurationInfo(before);
                this.dropAllSubmittedChanges();
                if (!ci.getLatestChanges().isEmpty()) {
                    this.currentConfigInfo = ci;
                }
                throw new BulkSettingException(ex.getMessage(), ex);
            }
        }
        ConfigurationInfo configurationInfo = this.buildConfigurationInfo(before);
        for (ConfigurationParameterInfo configurationParameterInfo : configurationInfo.getLatestChanges()) {
            ParameterPath path = ParameterPath.valueOf((String)configurationParameterInfo.getPathName());
            if (!submittedChanges.containsKey(path)) {
                this.dropAllSubmittedChanges();
                this.currentConfigInfo = configurationInfo;
                throw new BulkSettingException("the parameter " + configurationParameterInfo.getPathName() + " was not supposed to change from " + before.getCurrentValueForParameter(configurationParameterInfo.getPathName()) + " to " + configurationParameterInfo.getCurrentValue());
            }
            if (((String)submittedChanges.get(path)).equals(configurationParameterInfo.getCurrentValue())) continue;
            this.dropAllSubmittedChanges();
            this.currentConfigInfo = configurationInfo;
            throw new BulkSettingException("wrong value for parameter : " + path.toString() + ", expected : " + (String)submittedChanges.get(path) + ", actual : " + configurationParameterInfo.getCurrentValue());
        }
        for (Map.Entry<String, String> entry : categoriesToCommit.entrySet()) {
            String category = entry.getKey();
            String tag = entry.getValue();
            this.getCategoryHandler(category).setRunningConfiguration(tag);
        }
        this.dropAllSubmittedChanges();
        this.currentConfigInfo = this.buildConfigurationInfo(before);
    }

    public Set<String> findAvailableConfigurationsForCategory(String category) {
        return this.configurationProxy.findAvailableConfigurationsForCategory(category);
    }

    public void setSingleParameter(String componentName, String parameterName, Object value) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter " + new ParameterPath(componentName, parameterName)));
            return;
        }
        Map<String, Map<String, String>> previousChanges = this.getAllSubmittedChanges();
        this.dropAllSubmittedChanges();
        this.submitChange(componentName, parameterName, value);
        this.commitBulkChange(Collections.EMPTY_MAP);
        this.dropAllSubmittedChanges();
        for (Map.Entry<String, Map<String, String>> entry : previousChanges.entrySet()) {
            String comp = entry.getKey();
            for (Map.Entry<String, String> e : entry.getValue().entrySet()) {
                String parmName = e.getKey();
                String parmVal = e.getValue();
                this.submitChange(comp, parmName, parmVal);
            }
        }
    }

    public ConfigurationInfo getConfigurationInfo() {
        return this.currentConfigInfo;
    }

    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        return this.getParameterSet(componentName).getCurrentValues(categorySet).entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> (String)entry.getValue()));
    }

    public boolean isConfigurationProxyAvailable() {
        return this.configurationProxy.isAvailable();
    }
}

