/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigUtils {
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";
    public static final String SAFE_CONFIG_NAME = "safe";

    private ConfigUtils() {
    }

    public static Map<String, String> parseConfigurationString(Set<String> categorySet, String ... configNames) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : configNames) {
            if (s.isEmpty()) {
                res.put("", "");
                continue;
            }
            if (!s.contains(":")) {
                res.put("", s);
                continue;
            }
            Object[] keyVal = s.split(":", -1);
            if (keyVal.length != 2) {
                throw new IllegalArgumentException("wrong configuration string representation : " + Arrays.toString(keyVal));
            }
            if (categorySet != null && !categorySet.contains(keyVal[0])) {
                throw new IllegalArgumentException("unexisting category " + (String)keyVal[0]);
            }
            res.put(keyVal[0], (String)keyVal[1]);
        }
        return res;
    }

    public static Map<String, String> parseConfigurationStringWithDefaults(Set<String> categories, String ... taggedCategories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String cat : categories) {
            res.put(cat, "");
        }
        if (taggedCategories != null) {
            res.putAll(ConfigUtils.parseConfigurationString(categories, taggedCategories));
        }
        return res;
    }

    public static Set<String> parseCategories(Set<String> categorySet, String ... categories) {
        HashSet<String> res = new HashSet<String>();
        for (String cat : categories) {
            if (!categorySet.contains(cat)) {
                throw new IllegalArgumentException("unexisting category " + cat);
            }
            res.add(cat);
        }
        return res;
    }
}

