/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPanel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public final class AutoRefreshManager {
    private final LsstTrendingPlugin plugin;
    private PeriodicTask launcher;
    private volatile ExecutorService executor;
    private final int EXECUTOR_MAX_THREADS = 2;
    private PageListener pageListener;
    private volatile long[] delayBounds;

    public AutoRefreshManager(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
    }

    public synchronized void start() {
        TrendingPreferences pref = this.plugin.getPreferences();
        this.setDelay(pref.getRefreshMin(), pref.getRefreshMax(), TimeUnit.SECONDS);
        ThreadFactory tFactory = new ThreadFactory(){
            ThreadFactory delegate = Executors.defaultThreadFactory();
            int id = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setName("Auto-Refresh Executor " + this.id++);
                return thread;
            }
        };
        this.executor = Executors.newFixedThreadPool(2, tFactory);
        Scheduler scheduler = this.plugin.getConsole().getScheduler();
        this.launcher = new PeriodicTask(scheduler, this::launch, false, "Auto Refresh Launcher", Level.WARNING, this.delayBounds[0], TimeUnit.MILLISECONDS);
        this.launcher.start(this.delayBounds[0], TimeUnit.MILLISECONDS);
        this.pageListener = pe -> {
            if (pe.getID() == 3999) {
                try {
                    TrendingPanel page = (TrendingPanel)pe.getPageContext().getPage();
                    SwingUtilities.invokeLater(() -> {
                        try {
                            int n = page.numberOfRegions();
                            for (int i = 0; i < n; ++i) {
                                PlotRegion region = page.region(i);
                                Plotter plotter = region.currentPlot();
                                if (plotter == null || !(plotter instanceof TrendPlotter)) continue;
                                this.executor.execute(() -> this.refresh(((TrendPlotter)plotter).getTrends()));
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
        ((Studio)Application.getApplication()).getPageManager().addPageListener(this.pageListener);
    }

    public synchronized void stop() {
        ExecutorService exec = this.executor;
        this.executor = null;
        this.launcher.cancel(true);
        this.launcher = null;
        ((Studio)Application.getApplication()).getPageManager().removePageListener(this.pageListener);
        this.pageListener = null;
        exec.shutdownNow();
    }

    private void setDelay(long min, long max, TimeUnit unit) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.delayBounds = min == max ? new long[]{TimeUnit.MILLISECONDS.convert(min, unit)} : new long[]{TimeUnit.MILLISECONDS.convert(min, unit), TimeUnit.MILLISECONDS.convert(max, unit)};
    }

    public synchronized void updatePreferences() {
        TrendingPreferences pref = this.plugin.getPreferences();
        long minDelay = this.delayBounds[0];
        this.setDelay(pref.getRefreshMin(), pref.getRefreshMax(), TimeUnit.SECONDS);
        if (minDelay != this.delayBounds[0] && this.launcher != null) {
            this.launcher.setPeriod(this.delayBounds[0], TimeUnit.MILLISECONDS);
        }
    }

    private void launch() {
        SwingUtilities.invokeLater(this::findRegionsToRefresh);
    }

    private void findRegionsToRefresh() {
        try {
            this.plugin.getPages().forEach(page -> {
                if (page.isShowing()) {
                    int n = page.numberOfRegions();
                    for (int i = 0; i < n; ++i) {
                        PlotRegion region = page.region(i);
                        Plotter plotter = region.currentPlot();
                        if (plotter == null || !(plotter instanceof TrendPlotter)) continue;
                        this.executor.execute(() -> this.refresh(((TrendPlotter)plotter).getTrends()));
                    }
                }
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void refresh(List<Trend> trends) {
        boolean needRefresh = trends.stream().anyMatch(trend -> this.needsRefresh((Trend)trend));
        if (needRefresh) {
            long time = System.currentTimeMillis();
            trends.forEach(trend -> trend.setTimestamp(time));
            this.plugin.refresh(trends);
        }
    }

    private boolean needsRefresh(Trend trend) {
        long delay;
        TimeWindow tw = trend.getTimeWindow();
        if (tw.isFixed() && tw.getUpperEdge() < tw.getLastUseTime() || trend.getData() == null) {
            return false;
        }
        if (this.delayBounds.length == 1) {
            delay = this.delayBounds[0];
        } else {
            delay = Math.round((double)this.timeToNextPoint(trend.getData()) * 1.1);
            delay = Math.max(delay, this.delayBounds[0]);
            delay = Math.min(delay, this.delayBounds[1]);
        }
        return trend.getTimestamp() + delay < System.currentTimeMillis();
    }

    private long timeToNextPoint(TrendData data) {
        long[] time = data.getTime();
        if (time == null) {
            return this.delayBounds[0];
        }
        int n = time.length;
        if (n < 2) {
            return this.delayBounds[0];
        }
        return (time[n - 1] - time[0]) / (long)n;
    }
}

