/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.plots;

import hep.aida.IManagedObject;
import hep.aida.ref.tree.Tree;
import hep.aida.util.XMLUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.StatusMessageListener;

class PlotsListener
implements StatusMessageListener {
    private final FreeHEPLookup lookup;
    private final Studio studio = (Studio)Application.getApplication();
    private final PlotFactory plotFactory;
    private final FTreeProvider treeProvider;
    private final FTree tree;
    private final Tree masterTree;

    public PlotsListener() {
        this.lookup = this.studio.getLookup();
        this.plotFactory = (PlotFactory)this.lookup.lookup(PlotFactory.class);
        this.treeProvider = (FTreeProvider)this.lookup.lookup(FTreeProvider.class);
        this.tree = this.treeProvider.tree("Trending");
        AIDAPlugin aidaPlugin = (AIDAPlugin)this.lookup.lookup(AIDAPlugin.class);
        if (aidaPlugin == null) {
            String aidaName = AIDAPlugin.class.getName();
            for (PluginInfo p : this.studio.getPluginMap().getPlugins()) {
                if (!aidaName.equals(p.getMainClass())) continue;
                this.studio.loadPlugins(Collections.singletonList(p));
                break;
            }
            aidaPlugin = (AIDAPlugin)this.lookup.lookup(AIDAPlugin.class);
        }
        this.masterTree = ((AIDAPlugin)this.lookup.lookup(AIDAPlugin.class)).aidaMasterTree();
    }

    public void onStatusMessage(StatusMessage msg) {
        if (!(msg instanceof StatusSubsystemData)) {
            return;
        }
        StatusSubsystemData plotsMsg = (StatusSubsystemData)msg;
        String source = msg.getOriginAgentInfo().getName();
        List plots = plotsMsg.getEncodedData().getListOfKeyValueData(KeyValueData.KeyValueDataType.KeyValuePlotData);
        if (this.tree != null) {
            for (KeyValueData d : plots) {
                String plot = (String)((Object)d.getValue());
                String key = d.getKey();
                String plotPath = source;
                if (!key.isEmpty()) {
                    plotPath = plotPath + "/" + key;
                    plotPath = plotPath.replace("//", "/");
                }
                String dirPath = plotPath.substring(0, plotPath.lastIndexOf("/"));
                String plotName = plotPath.substring(plotPath.lastIndexOf("/") + 1);
                try {
                    this.masterTree.find(dirPath);
                }
                catch (IllegalArgumentException e) {
                    this.masterTree.mkdirs(dirPath);
                }
                StringTokenizer st = new StringTokenizer(dirPath, "/");
                String[] treePath = new String[st.countTokens() + 1];
                int count = 0;
                while (st.hasMoreTokens()) {
                    treePath[count++] = st.nextToken();
                }
                treePath[count] = plotName;
                FTreePath path = new FTreePath(treePath);
                FTreeNode node = this.tree.findNode(path);
                try {
                    IManagedObject obj = XMLUtils.createManagedObject((String)plot);
                    boolean removeNode = node != null;
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            if (removeNode) {
                                this.tree.treeChanged(new FTreeNodeRemovedNotification((Object)this.studio, path));
                            }
                            this.tree.treeChanged(new FTreeNodeAddedNotification((Object)this.studio, path, (Object)obj));
                        });
                    }
                    catch (InterruptedException | InvocationTargetException x) {
                        throw new RuntimeException(x);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not create IManagedObject", ioe);
                }
            }
        }
    }
}

