/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.TreeWalkerDiag;

public final class TreeWalkerUtils {
    private TreeWalkerUtils() {
    }

    public static <A> void proceduralWalk(ComponentLookup lookup, String startingNodeName, Class<A> klass, Consumer<A> pre, Consumer<A> post) {
        TreeWalkerUtils.proceduralBiWalk(lookup, startingNodeName, klass, pre == null ? (n, o) -> {} : (n, o) -> pre.accept(o), post == null ? (n, o) -> {} : (n, o) -> post.accept(o));
    }

    public static void proceduralNodeWalk(ComponentLookup lookup, String startingNodeName, Consumer<ComponentNode> pre, Consumer<ComponentNode> post) {
        TreeWalkerUtils.proceduralBiWalk(lookup, startingNodeName, Object.class, pre == null ? (n, o) -> {} : (n, o) -> pre.accept((ComponentNode)n), post == null ? (n, o) -> {} : (n, o) -> post.accept((ComponentNode)n));
    }

    public static <A> void proceduralBiWalk(ComponentLookup lookup, String startingNodeName, Class<A> klass, BiConsumer<ComponentNode, A> pre, BiConsumer<ComponentNode, A> post) {
        TreeWalkerUtils.treeBiWalk(lookup, startingNodeName, klass, (n, o) -> {
            if (pre != null) {
                pre.accept((ComponentNode)n, (Object)o);
            }
            return TreeWalkerDiag.GO;
        }, (n, o) -> {
            if (post != null) {
                post.accept((ComponentNode)n, (Object)o);
            }
        });
    }

    public static <A> void treeWalk(ComponentLookup lookup, String startingNodeName, Class<A> klass, Function<A, TreeWalkerDiag> func, Consumer<A> post) {
        TreeWalkerUtils.treeBiWalk(lookup, startingNodeName, klass, func == null ? (n, o) -> TreeWalkerDiag.GO : (n, o) -> (TreeWalkerDiag)((Object)((Object)func.apply(o))), post == null ? (n, o) -> {} : (n, o) -> post.accept(o));
    }

    public static <A> void treeBiWalk(ComponentLookup lookup, String startingNodeName, Class<A> klass, BiFunction<ComponentNode, A, TreeWalkerDiag> func, BiConsumer<ComponentNode, A> post) {
        ComponentNode startFromNode;
        ComponentNode componentNode = startFromNode = startingNodeName == null ? lookup.getTopComponentNode() : lookup.getNodeByName(startingNodeName);
        if (startFromNode != null) {
            BiFunction<ComponentNode, Object, TreeWalkerDiag> f = func == null ? (n, o) -> TreeWalkerDiag.GO : func;
            BiConsumer<ComponentNode, Object> p = post == null ? (n, o) -> {} : post;
            TreeWalkerUtils.treeNodeWalkInternal(startFromNode, (n, o) -> {
                if (klass.isAssignableFrom(o.getClass())) {
                    return (TreeWalkerDiag)((Object)((Object)f.apply((ComponentNode)n, o)));
                }
                return TreeWalkerDiag.GO;
            }, (n, o) -> {
                if (klass.isAssignableFrom(o.getClass())) {
                    p.accept((ComponentNode)n, o);
                }
            });
        }
    }

    private static TreeWalkerDiag treeNodeWalkInternal(ComponentNode node, BiFunction<ComponentNode, Object, TreeWalkerDiag> func, BiConsumer<ComponentNode, Object> post) {
        TreeWalkerDiag diag = TreeWalkerDiag.GO;
        diag = func.apply(node, node.getComponent());
        switch (diag) {
            case STOP: {
                return diag;
            }
            case HANDLING_CHILDREN: {
                return diag;
            }
        }
        for (ComponentNode child : node.getChildren()) {
            TreeWalkerDiag childRes = TreeWalkerUtils.treeNodeWalkInternal(child, func, post);
            if (!childRes.equals((Object)TreeWalkerDiag.STOP)) continue;
            return childRes;
        }
        post.accept(node, node.getComponent());
        return diag;
    }
}

