/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.lsst.ccs.localdb.configdb.model.AParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.GhostParameterDescription;
import org.lsst.ccs.localdb.configdb.model.ParameterConfiguration;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;

@Entity
class PastParameterConfiguration
extends ParameterConfiguration {
    private static final long serialVersionUID = 1648990234116895047L;
    @Id
    private long id;
    @ManyToOne
    private GhostParameterDescription parameterDescription;

    PastParameterConfiguration() {
    }

    PastParameterConfiguration(GhostParameterDescription ghostDescription, AParameterConfiguration oldConfig) {
        super(oldConfig.getValue());
        if (oldConfig.getId() == 0L) {
            throw new IllegalArgumentException("trying to create historical data with a non-registered object");
        }
        if (ghostDescription.getId() != oldConfig.getDescription().getId()) {
            throw new IllegalArgumentException("description and its ghost with different ids");
        }
        this.id = oldConfig.getId();
        this.parameterDescription = ghostDescription;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public ParameterDescription getDescription() {
        return this.parameterDescription;
    }

    GhostParameterDescription getParameterDescription() {
        return this.parameterDescription;
    }

    void setParameterDescription(GhostParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
    }
}

