/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import javax.persistence.MappedSuperclass;
import org.lsst.ccs.localdb.configdb.model.ImmutableStateException;
import org.lsst.ccs.localdb.configdb.model.ParameterBase;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.configdb.model.PathObject;

@MappedSuperclass
public abstract class ParameterDescription
implements Serializable,
PathObject {
    private static final long serialVersionUID = 5660908759518934491L;
    protected String description;
    private ParameterBase parameterBase;
    private String simpleName;
    private String category;
    private int level = 0;

    protected ParameterDescription() {
    }

    protected ParameterDescription(ParameterBase parameterBase) {
        this.setParameterBase(parameterBase);
    }

    protected ParameterDescription(ParameterDescription other) {
        this.setId(other.getId());
        this.setParameterBase(other.parameterBase);
        this.description = other.description;
        this.simpleName = other.simpleName;
        this.level = other.level;
        this.category = other.category;
    }

    public abstract long getId();

    protected abstract void setId(long var1);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public ParameterBase getParameterBase() {
        return this.parameterBase;
    }

    protected void setParameterBase(ParameterBase parameterBase) {
        this.parameterBase = parameterBase;
        String codeName = parameterBase.getCodeName();
        if (codeName == null) {
            codeName = "";
        }
        this.simpleName = String.format("%s/%s/%s", parameterBase.getComponentName(), codeName, parameterBase.getParameterName());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("simple name read Only");
        }
        if (this.simpleName == null || "".equals(this.simpleName)) {
            this.simpleName = simpleName;
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Category read Only");
        }
        this.category = category;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Level read Only");
        }
        this.level = level;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathObject)) {
            return false;
        }
        PathObject that = (PathObject)o;
        return this.parameterBase.getPath().equals(that.getPath());
    }

    public int hashCode() {
        return this.parameterBase.getPath().hashCode();
    }

    public String toString() {
        return "{" + this.getId() + ": base=" + this.parameterBase + '}';
    }

    public String getComponentName() {
        return this.parameterBase.getComponentName();
    }

    public String getCodeName() {
        return this.parameterBase.getCodeName();
    }

    public String getParameterName() {
        return this.parameterBase.getParameterName();
    }

    public String getDefaultValue() {
        return this.parameterBase.getDefaultValue();
    }

    @Override
    public ParameterPath getPath() {
        return this.parameterBase.getPath();
    }

    public String getTypeName() {
        return this.parameterBase.getTypeName();
    }
}

