/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.lsst.ccs.localdb.configdb.model.ImmutableStateException;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.configdb.model.PathObject;

@MappedSuperclass
public abstract class ParameterConfiguration
implements Serializable,
PathObject {
    private static final long serialVersionUID = 774337848554181101L;
    protected String value;
    @Transient
    protected Exception reConfigurationFailure;

    protected ParameterConfiguration() {
    }

    protected ParameterConfiguration(String value) {
        this.value = value;
    }

    public abstract long getId();

    protected abstract void setId(long var1);

    public boolean isReadOnly() {
        return this.getId() != 0L;
    }

    public Exception getReConfigurationFailure() {
        return this.reConfigurationFailure;
    }

    public void setReConfigurationFailure(Exception reConfigurationFail) {
        this.reConfigurationFailure = reConfigurationFail;
    }

    public abstract ParameterDescription getDescription();

    public String getValue() {
        return this.value;
    }

    void setValue(String value) {
        this.value = value;
    }

    public void modifyValue(String value) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("read only value");
        }
        this.setValue(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathObject)) {
            return false;
        }
        PathObject that = (PathObject)o;
        ParameterDescription description = this.getDescription();
        return description.getPath().equals(that.getPath());
    }

    public String toString() {
        return this.getId() + "{" + this.getId() + ": description=" + this.getDescription() + ", value='" + this.value + '\'' + '}';
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    @Override
    public ParameterPath getPath() {
        return this.getDescription().getPath();
    }

    public boolean hasChanged() {
        return false;
    }
}

