/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.power.data.RebPsState;

public class RebPsControlPanel
extends JPanel {
    private static final Font FONT = new Font("Tahoma", 1, 12);
    private static final Color RED = new Color(180, 0, 0);
    private static final Color GREEN = new Color(0, 180, 0);
    private static final Color YELLOW = new Color(200, 180, 0);
    private static final Color GREY = Color.GRAY;
    private static final int N_REB = 3;
    private static final int N_PS = 8;
    private static final int[] psNumsSR = new int[]{-1, 0, 1, 2, 4, 3, 5, 6};
    private static final int[] psNumsCR = new int[]{-1, 0, 1, 2, 4, 3, 5, 6};
    private static final Map<Integer, Integer> psNumMapSR = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> psNumMapCR = new HashMap<Integer, Integer>();
    private static final String[] psNamesSR = new String[]{"Master", "Dig", "Ana", "OD", "ClkL", "ClkH", "Htr", "HVbias"};
    private static final String[] psNamesCR = new String[]{"Master", "Dig", "Ana", "OD", "ClkL", "ClkH", "Dphi", "HVbias"};
    private final CommandSender gui;
    private final JPanel pnlPowerState = new JPanel();
    private final JLabel lblPowerState = new JLabel("System State: ");
    private final JLabel lblPowerStateValue = new JLabel("....");
    private final JPanel pnlPsId = new JPanel();
    private final JLabel lblPsId = new JLabel("PS ID: ");
    private final JLabel lblPsIdValue = new JLabel("....");
    private final JPanel pnlMainPower = new JPanel();
    private final JLabel lblMainPower = new JLabel("Main Power: ");
    private final JButton btnMainPower = new JButton("");
    private final JPanel pnlPowerPeriod = new JPanel();
    private final JLabel lblPowerPeriod = new JLabel("Update Period: ");
    private final JTextField tfPowerPeriod = new JTextField("...");
    private final JLabel lblPowerPeriodUnits = new JLabel("sec");
    private final JPanel pnlPowerControl = new JPanel();
    private final JLabel[] lblPsNames = new JLabel[8];
    private final JButton[][] btnToggle = new JButton[3][8];
    private final JButton[] btnSeqOn = new JButton[3];
    private final JButton[] btnSeqOff = new JButton[3];
    private final JTextField[] tfBiasDac = new JTextField[3];
    private final JLabel lblDphi = new JLabel("Dphi DAC");
    private final JTextField[] tfDphiDac = new JTextField[3];
    private final int[] biasDacs = new int[3];
    private final int[] dphiDacs = new int[3];
    private boolean gotCR = false;
    private String powerName;
    private double powerPeriod = 5.0;
    private int[] psNums = psNumsSR;
    private static final long serialVersionUID = 1L;

    public RebPsControlPanel(CommandSender gui) {
        for (int j = 0; j < 8; ++j) {
            psNumMapSR.put(psNumsSR[j], j);
            psNumMapCR.put(psNumsCR[j], j);
        }
        this.gui = gui;
        this.initComponents();
        new UpdatePowerStatus(new RebPsState(0, -1, new int[0], new double[0], new double[0], "")).run();
        new DisableSystem().run();
    }

    public void setSubsystems(String powerName) {
        this.powerName = powerName;
    }

    private void initComponents() {
        Dimension ds = this.lblPowerStateValue.getPreferredSize();
        ds.width = 60;
        this.lblPowerStateValue.setPreferredSize(ds);
        this.lblPowerStateValue.setMinimumSize(ds);
        Dimension di = this.lblPsIdValue.getPreferredSize();
        di.width = 50;
        this.lblPsIdValue.setPreferredSize(di);
        this.lblPsIdValue.setMinimumSize(di);
        Dimension dc = this.btnMainPower.getPreferredSize();
        dc.height = 16;
        this.btnMainPower.setPreferredSize(dc);
        this.btnMainPower.setMinimumSize(dc);
        this.btnMainPower.setFocusable(false);
        this.btnMainPower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RebPsControlPanel.this.toggleMainPower();
            }
        });
        Dimension dp = this.tfPowerPeriod.getPreferredSize();
        dp.width = 50;
        this.tfPowerPeriod.setPreferredSize(dp);
        this.tfPowerPeriod.setMinimumSize(dp);
        this.tfPowerPeriod.setHorizontalAlignment(0);
        this.tfPowerPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RebPsControlPanel.this.setUpdatePeriod();
            }
        });
        for (int j = 0; j < 8; ++j) {
            this.lblPsNames[j] = new JLabel(psNamesSR[j]);
        }
        for (int reb = 0; reb < 3; ++reb) {
            JButton btn = new JButton("On");
            btn.setForeground(GREEN);
            btn.setName(reb + "");
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    RebPsControlPanel.this.sequencePower(Integer.valueOf(name), true);
                }
            });
            this.btnSeqOn[reb] = btn;
            btn = new JButton("Off");
            btn.setForeground(RED);
            btn.setName(String.valueOf(reb));
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    RebPsControlPanel.this.sequencePower(Integer.valueOf(name), false);
                }
            });
            this.btnSeqOff[reb] = btn;
            for (int ps = 0; ps < 8; ++ps) {
                btn = new JButton(" ");
                btn.setName(String.format("%02d", 10 * reb + ps));
                btn.setFocusable(false);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String name = ((JButton)evt.getSource()).getName();
                        RebPsControlPanel.this.togglePower(Integer.valueOf(name.substring(0, 1)), Integer.valueOf(name.substring(1, 2)));
                    }
                });
                this.btnToggle[reb][ps] = btn;
            }
            JTextField tf = new JTextField("...");
            tf.setName("B" + reb);
            Dimension dd = tf.getPreferredSize();
            dd.width = 60;
            tf.setPreferredSize(dd);
            tf.setMinimumSize(dd);
            tf.setHorizontalAlignment(0);
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JTextField)evt.getSource()).getName();
                    RebPsControlPanel.this.setBiasDac(Integer.valueOf(name.substring(1)));
                }
            });
            this.tfBiasDac[reb] = tf;
            tf = new JTextField("...");
            tf.setName("D" + reb);
            tf.setPreferredSize(dd);
            tf.setMinimumSize(dd);
            tf.setHorizontalAlignment(0);
            tf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JTextField)evt.getSource()).getName();
                    RebPsControlPanel.this.setDphiDac(Integer.valueOf(name.substring(1)));
                }
            });
            this.tfDphiDac[reb] = tf;
        }
        this.pnlPowerState.add(this.lblPowerState);
        this.pnlPowerState.add(this.lblPowerStateValue);
        this.pnlPsId.add(this.lblPsId);
        this.pnlPsId.add(this.lblPsIdValue);
        this.pnlMainPower.add(this.lblMainPower);
        this.pnlMainPower.add(this.btnMainPower);
        this.pnlPowerPeriod.add(this.lblPowerPeriod);
        this.pnlPowerPeriod.add(this.tfPowerPeriod);
        this.pnlPowerPeriod.add(this.lblPowerPeriodUnits);
        this.pnlPowerControl.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 6, 4, 6);
        gbp.gridx = 1;
        gbp.gridwidth = 2;
        gbp.gridy = 0;
        this.pnlPowerControl.add((Component)new JLabel("Sequenced"), gbp);
        gbp.gridx += 2;
        gbp.gridwidth = 1;
        for (int j = 0; j < 8; ++j) {
            this.pnlPowerControl.add((Component)this.lblPsNames[j], gbp);
            ++gbp.gridx;
        }
        this.pnlPowerControl.add((Component)new JLabel("Bias DAC"), gbp);
        gbp.gridx = 0;
        ++gbp.gridy;
        for (int reb = 0; reb < 3; ++reb) {
            this.pnlPowerControl.add((Component)new JLabel("REB " + reb), gbp);
            ++gbp.gridx;
            this.pnlPowerControl.add((Component)this.btnSeqOn[reb], gbp);
            ++gbp.gridx;
            this.pnlPowerControl.add((Component)this.btnSeqOff[reb], gbp);
            ++gbp.gridx;
            for (int ps = 0; ps < 8; ++ps) {
                this.pnlPowerControl.add((Component)this.btnToggle[reb][ps], gbp);
                ++gbp.gridx;
            }
            this.pnlPowerControl.add((Component)this.tfBiasDac[reb], gbp);
            gbp.gridx = 0;
            ++gbp.gridy;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 10, 6, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.pnlPowerState, gbc);
        ++gbc.gridx;
        this.add((Component)this.pnlPsId, gbc);
        ++gbc.gridx;
        this.add((Component)this.pnlMainPower, gbc);
        ++gbc.gridx;
        this.add((Component)this.pnlPowerPeriod, gbc);
        gbc.insets = new Insets(6, 6, 6, 6);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        this.add((Component)this.pnlPowerControl, gbc);
    }

    private void reshape(boolean isCR) {
        if (isCR == this.gotCR) {
            return;
        }
        this.gotCR = isCR;
        String[] psNames = this.gotCR ? psNamesCR : psNamesSR;
        for (int j = 0; j < 8; ++j) {
            this.lblPsNames[j].setText(psNames[j]);
        }
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 6, 4, 6);
        if (this.gotCR) {
            int j;
            gbp.gridx = 12;
            gbp.gridy = 0;
            this.pnlPowerControl.add((Component)this.lblDphi, gbp);
            for (j = 0; j < 2; ++j) {
                ++gbp.gridy;
                this.pnlPowerControl.add((Component)this.tfDphiDac[j], gbp);
            }
            for (j = 3; j < 8; ++j) {
                this.pnlPowerControl.remove(this.btnToggle[2][j]);
            }
            this.pnlPowerControl.remove(this.tfBiasDac[2]);
        } else {
            int j;
            this.pnlPowerControl.remove(this.lblDphi);
            for (j = 0; j < 2; ++j) {
                this.pnlPowerControl.remove(this.tfDphiDac[j]);
            }
            gbp.gridx = 6;
            gbp.gridy = 3;
            for (j = 3; j < 8; ++j) {
                this.pnlPowerControl.add((Component)this.btnToggle[2][j], gbp);
                ++gbp.gridx;
            }
            this.pnlPowerControl.add((Component)this.tfBiasDac[2], gbp);
        }
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.tfPowerPeriod.getText());
            this.gui.sendCommand(this.powerName, null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.tfPowerPeriod.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfPowerPeriod.setText(String.valueOf(this.powerPeriod));
        }
    }

    private void toggleMainPower() {
        this.gui.sendCommand(this.powerName, null, "toggleMainPower", new Object[0]);
    }

    private void sequencePower(int reb, boolean on) {
        this.gui.sendCommand(this.powerName, null, "sequencePower", new Object[]{reb, on});
    }

    private void togglePower(int reb, int ps) {
        this.gui.sendCommand(this.powerName, null, "togglePower", new Object[]{reb, this.psNums[ps]});
    }

    private void setBiasDac(int reb) {
        try {
            double value = Integer.valueOf(this.tfBiasDac[reb].getText()).intValue();
            this.gui.sendCommand(this.powerName, null, "setBiasDac", new Object[]{reb, value});
            this.tfBiasDac[reb].setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfBiasDac[reb].setText(String.valueOf(this.biasDacs[reb]));
        }
    }

    private void setDphiDac(int reb) {
        try {
            double value = Integer.valueOf(this.tfDphiDac[reb].getText()).intValue();
            this.gui.sendCommand(this.powerName, null, "setDphiDac", new Object[]{reb, value});
            this.tfDphiDac[reb].setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfDphiDac[reb].setText(String.valueOf(this.dphiDacs[reb]));
        }
    }

    public void updateControlPanel(int id, RebPsState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disableSystem(int id) {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static /* synthetic */ int[] access$602(RebPsControlPanel x0, int[] x1) {
        x0.psNums = x1;
        return x1;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            RebPsControlPanel.this.lblPowerStateValue.setText("STOPPED");
            RebPsControlPanel.this.lblPowerStateValue.setForeground(RED);
            RebPsControlPanel.this.btnMainPower.setEnabled(false);
            RebPsControlPanel.this.btnMainPower.setBackground(GREY);
            RebPsControlPanel.this.tfPowerPeriod.setEnabled(false);
            for (int reb = 0; reb < 3; ++reb) {
                RebPsControlPanel.this.btnSeqOn[reb].setEnabled(false);
                RebPsControlPanel.this.btnSeqOff[reb].setEnabled(false);
                for (int ps = 0; ps < 8; ++ps) {
                    RebPsControlPanel.this.btnToggle[reb][ps].setEnabled(false);
                    RebPsControlPanel.this.btnToggle[reb][ps].setBackground(GREY);
                }
                RebPsControlPanel.this.tfBiasDac[reb].setEnabled(false);
                RebPsControlPanel.this.tfDphiDac[reb].setEnabled(false);
            }
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final RebPsState rs;

        UpdatePowerStatus(RebPsState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            Map psNumMap;
            boolean isCR = this.rs.getpsId().startsWith("CR");
            if (isCR) {
                RebPsControlPanel.access$602(RebPsControlPanel.this, psNumsCR);
                psNumMap = psNumMapCR;
            } else {
                RebPsControlPanel.access$602(RebPsControlPanel.this, psNumsSR);
                psNumMap = psNumMapSR;
            }
            RebPsControlPanel.this.reshape(isCR);
            RebPsControlPanel.this.lblPowerStateValue.setText("RUNNING");
            RebPsControlPanel.this.lblPowerStateValue.setForeground(GREEN);
            RebPsControlPanel.this.lblPsIdValue.setText(this.rs.getpsId());
            RebPsControlPanel.this.btnMainPower.setEnabled(true);
            int mps = this.rs.getMainPowerState();
            Color color = mps == 1 ? GREEN : (mps == 0 ? RED : GREY);
            RebPsControlPanel.this.btnMainPower.setBackground(color);
            RebPsControlPanel.this.tfPowerPeriod.setEnabled(true);
            RebPsControlPanel.this.powerPeriod = (double)this.rs.getTickMillis() / 1000.0;
            RebPsControlPanel.this.tfPowerPeriod.setText(String.valueOf(RebPsControlPanel.this.powerPeriod));
            int[] state = this.rs.getPowerState();
            double[] bDacs = this.rs.getHvBiasDacs();
            double[] dDacs = this.rs.getDphiDacs();
            for (int reb = 0; reb < 3; ++reb) {
                RebPsControlPanel.this.btnSeqOn[reb].setEnabled(true);
                RebPsControlPanel.this.btnSeqOff[reb].setEnabled(true);
                boolean present = reb < state.length;
                for (int ps = 0; ps < 8; ++ps) {
                    color = present ? ((state[reb] & 1 << ps) == 0 ? RED : GREEN) : GREY;
                    int j = (Integer)psNumMap.get(ps - 1);
                    RebPsControlPanel.this.btnToggle[reb][j].setEnabled(true);
                    RebPsControlPanel.this.btnToggle[reb][j].setBackground(color);
                }
                RebPsControlPanel.this.tfBiasDac[reb].setEnabled(true);
                int value = reb < bDacs.length ? (int)bDacs[reb] : 0;
                RebPsControlPanel.this.tfBiasDac[reb].setText(String.valueOf(value));
                ((RebPsControlPanel)RebPsControlPanel.this).biasDacs[reb] = value;
                RebPsControlPanel.this.tfDphiDac[reb].setEnabled(true);
                value = reb < dDacs.length ? (int)dDacs[reb] : 0;
                RebPsControlPanel.this.tfDphiDac[reb].setText(String.valueOf(value));
                ((RebPsControlPanel)RebPsControlPanel.this).dphiDacs[reb] = value;
            }
        }
    }
}

