/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public class TimeWindowPanel
extends JPanel {
    private final int MAX_YEARS = 50;
    private final int SECONDS_IN_YEAR = 31536000;
    private final int SECONDS_IN_DAY = 86400;
    private final int SECONDS_IN_HOUR = 3600;
    private final int SECONDS_IN_MINUTE = 60;
    private final int VSPACE = 5;
    private final int HSPACE = 10;
    private final TimePanel fromPanel;
    private final TimePanel toPanel;
    private final JTextField nameField;
    private final JCheckBox saveCheck;
    private static TimeWindow range;
    private static JButton okButton;

    private TimeWindowPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.fromPanel = new TimePanel(" Starting ");
        this.add(this.fromPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.toPanel = new TimePanel(" Ending ");
        this.add(this.toPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box saveBox = Box.createVerticalBox();
        saveBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Remember As "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.nameField = new JTextField();
        this.nameField.setColumns(30);
        this.nameField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TimeWindowPanel.this.saveCheck.setEnabled(!TimeWindowPanel.this.nameField.getText().trim().isEmpty());
            }
        });
        saveBox.add(this.nameField);
        saveBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.saveCheck = new JCheckBox("Remember between sessions");
        saveBox.add(this.saveCheck);
        this.add(saveBox);
        if (range == null) {
            this.fromPanel.setTime("now - 86400");
            this.toPanel.setTime("now");
            this.saveCheck.setEnabled(false);
        } else {
            this.fromPanel.setTime(range.getLowerEdgeString());
            this.toPanel.setTime(range.getUpperEdgeString());
            this.nameField.setText(range.getName());
            this.saveCheck.setSelected(range.isPersistent());
            this.saveCheck.setEnabled(true);
        }
    }

    public static TimeWindow editTimeWindow(JComponent parent, TimeWindow seed) {
        range = seed;
        okButton = new JButton("  OK  ");
        TimeWindowPanel tsp = new TimeWindowPanel();
        okButton.addActionListener(e -> {
            tsp.getRange();
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            range = null;
            Window w = SwingUtilities.getWindowAncestor(tsp);
            if (w != null) {
                w.setVisible(false);
            }
        });
        JOptionPane.showOptionDialog(parent, tsp, "Select time range", 2, -1, null, new Object[]{okButton, cancelButton}, null);
        okButton = null;
        return range;
    }

    private void checkValidy() {
        boolean ok = false;
        if (this.fromPanel.isDataValid() && this.toPanel.isDataValid()) {
            try {
                new TimeWindow(this.nameField.getText().trim(), this.fromPanel.getTime(), this.toPanel.getTime(), false);
                ok = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        okButton.setEnabled(ok);
    }

    private TimeWindow getRange() {
        String name = this.nameField.getText().trim();
        boolean persistent = !name.isEmpty() && this.saveCheck.isSelected();
        String start = this.fromPanel.getTime();
        String end = this.toPanel.getTime();
        if (range == null) {
            range = new TimeWindow(name, start, end, persistent);
        } else {
            range.setName(name);
            range.setLowerEdge(start);
            range.setUpperEdge(end);
            range.setPersistent(persistent);
        }
        return range;
    }

    private class TimePanel
    extends JPanel {
        private final JTextField _field;
        private final ButtonGroup _group;
        private final JRadioButton _absButton;
        private final JRadioButton _relButton;
        private final JSpinner _timeSpinner;
        private final JSpinner _yearSpinner;
        private final JSpinner _daySpinner;
        private final JSpinner _hourSpinner;
        private final JSpinner _minSpinner;
        private final JSpinner _secSpinner;
        private final SpinnerDateModel _timeSpinnerModel;
        private final SpinnerNumberModel _yearSpinnerModel;
        private final SpinnerNumberModel _daySpinnerModel;
        private final SpinnerNumberModel _hourSpinnerModel;
        private final SpinnerNumberModel _minSpinnerModel;
        private final SpinnerNumberModel _secSpinnerModel;
        private boolean _listen = false;

        TimePanel(String title) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            Box box = Box.createHorizontalBox();
            this.add(box);
            this._field = new JTextField(20);
            this._field.setMaximumSize(this._field.getPreferredSize());
            this._field.addCaretListener(e -> this.updateFromField());
            box.add(this._field);
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            box.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            box = Box.createHorizontalBox();
            this.add(box);
            this._group = new ButtonGroup();
            this._absButton = new JRadioButton("Fixed: ");
            this._absButton.addActionListener(e -> {
                this.enableRelative(false);
                this.updateFromAbsolute();
            });
            this._group.add(this._absButton);
            box.add(this._absButton);
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            this._timeSpinnerModel = new SpinnerDateModel(new Date(), new Date(System.currentTimeMillis() - 1576800000000L), new Date(System.currentTimeMillis() + 1576800000000L), 10);
            this._timeSpinner = new JSpinner(this._timeSpinnerModel);
            this._timeSpinner.setEditor(new JSpinner.DateEditor(this._timeSpinner, " MM/dd/yyyy HH:mm:ss"));
            this._timeSpinner.addChangeListener(e -> this.updateFromAbsolute());
            this._timeSpinner.setMaximumSize(this._timeSpinner.getPreferredSize());
            box.add(this._timeSpinner);
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            box.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            box = Box.createHorizontalBox();
            this.add(box);
            this._relButton = new JRadioButton();
            this._relButton.addActionListener(e -> {
                this.enableRelative(true);
                this.updateFromRelative();
            });
            this._group.add(this._relButton);
            box.add(this._relButton);
            ChangeListener relListener = e -> this.updateFromRelative();
            this._yearSpinnerModel = new SpinnerNumberModel(0, 0, 50, 1);
            this._yearSpinner = new JSpinner(this._yearSpinnerModel);
            this._yearSpinner.addChangeListener(relListener);
            box.add(this._yearSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("years"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._daySpinnerModel = new SpinnerNumberModel(0, 0, 999, 1);
            this._daySpinner = new JSpinner(this._daySpinnerModel);
            this._daySpinner.addChangeListener(relListener);
            box.add(this._daySpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("days"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._hourSpinnerModel = new SpinnerNumberModel(0, 0, 99, 1);
            this._hourSpinner = new JSpinner(this._hourSpinnerModel);
            this._hourSpinner.addChangeListener(relListener);
            box.add(this._hourSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("hours"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._minSpinnerModel = new SpinnerNumberModel(0, 0, 99, 1);
            this._minSpinner = new JSpinner(this._minSpinnerModel);
            this._minSpinner.addChangeListener(relListener);
            box.add(this._minSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("minutes"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._secSpinnerModel = new SpinnerNumberModel(0, 0, 999, 1);
            this._secSpinner = new JSpinner(this._secSpinnerModel);
            this._secSpinner.addChangeListener(relListener);
            box.add(this._secSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("seconds  in the past"));
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            box.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this._listen = true;
        }

        boolean isDataValid() {
            return this._field.getForeground().equals(Color.BLACK);
        }

        String getTime() {
            if (this._absButton.isSelected()) {
                this.updateFromAbsolute();
            } else {
                this.updateFromRelative();
            }
            return this._field.getText().trim();
        }

        void setTime(String time) {
            this._field.setText(time);
        }

        private void updateFromAbsolute() {
            if (this._listen) {
                this._listen = false;
                this._field.setText(TimeWindow.DATE_FORMAT.format(this._timeSpinnerModel.getDate()));
                this._field.setForeground(Color.BLACK);
                TimeWindowPanel.this.checkValidy();
                this._listen = true;
            }
        }

        private void updateFromRelative() {
            if (this._listen) {
                this._listen = false;
                int seconds = 31536000 * this._yearSpinnerModel.getNumber().intValue() + 86400 * this._daySpinnerModel.getNumber().intValue() + 3600 * this._hourSpinnerModel.getNumber().intValue() + 60 * this._minSpinnerModel.getNumber().intValue() + this._secSpinnerModel.getNumber().intValue();
                this._field.setText("now" + (seconds > 0 ? " - " + seconds : ""));
                this._field.setForeground(Color.BLACK);
                TimeWindowPanel.this.checkValidy();
                this._listen = true;
            }
        }

        private void updateFromField() {
            if (this._listen) {
                this._listen = false;
                String data = this._field.getText();
                try {
                    long edge = TimeWindow.parseEdge(data) * 1000L;
                    if (edge > 0L) {
                        long range;
                        long now = System.currentTimeMillis();
                        if (edge < now - (range = 1545264000000L) || edge > now + range) {
                            throw new IllegalArgumentException();
                        }
                        Date date = new Date(edge);
                        this._timeSpinnerModel.setValue(date);
                        this.enableRelative(false);
                    } else {
                        long years = (edge = -edge / 1000L) / 31536000L;
                        if (years > 50L) {
                            throw new IllegalArgumentException();
                        }
                        this._yearSpinnerModel.setValue((int)years);
                        int seconds = (int)(edge % 31536000L);
                        this._daySpinnerModel.setValue(seconds / 86400);
                        this._hourSpinnerModel.setValue((seconds %= 86400) / 3600);
                        this._minSpinnerModel.setValue((seconds %= 3600) / 60);
                        this._secSpinnerModel.setValue(seconds %= 60);
                        this.enableRelative(true);
                    }
                    this._field.setForeground(Color.BLACK);
                }
                catch (IllegalArgumentException x) {
                    this._field.setForeground(Color.RED);
                }
                TimeWindowPanel.this.checkValidy();
                this._listen = true;
            }
        }

        private void enableRelative(boolean relative) {
            this._timeSpinner.setEnabled(!relative);
            this._yearSpinner.setEnabled(relative);
            this._daySpinner.setEnabled(relative);
            this._hourSpinner.setEnabled(relative);
            this._minSpinner.setEnabled(relative);
            this._secSpinner.setEnabled(relative);
            if (relative) {
                this._relButton.setSelected(true);
            } else {
                this._absButton.setSelected(true);
            }
        }
    }
}

