/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;

@Entity
@Table(indexes={@Index(columnList="statDescId")})
public class StatData
implements Serializable {
    static final Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    private long id;
    private StatDesc statDesc;
    private StatTimeInterval timeInterval;
    private double average;
    private double sum2;
    private int n;
    private double minval;
    private double maxval;

    public StatData() {
    }

    public StatData(StatDesc d) {
        this.statDesc = d;
    }

    public StatData(StatDesc d, RawData x, StatTimeInterval timeInterval) {
        log.fine("new StatData from " + d + " and " + x);
        log.fine(x.getTime() + " " + x.getDoubleData());
        this.statDesc = d;
        this.average = x.getDoubleData();
        this.sum2 = this.average * this.average;
        this.minval = this.average;
        this.maxval = this.average;
        this.n = 1;
        this.timeInterval = timeInterval;
    }

    @Transient
    public double getSum() {
        return this.getAverage() * (double)this.getN();
    }

    public void setSum(double s) {
        this.setAverage(s / (double)this.getN());
    }

    @Transient
    public double getRMS() {
        return Math.sqrt(this.getSum2() / (double)this.getN() - this.getAverage() * this.getAverage());
    }

    public void accumulate(RawData x) {
        double sum = this.getSum();
        double d = x.getDoubleData();
        sum += d;
        this.setSum2(this.getSum2() + d * d);
        if (this.getN() == 0 || d > this.maxval) {
            this.maxval = d;
        }
        if (this.getN() == 0 || d < this.minval) {
            this.minval = d;
        }
        this.setN(this.getN() + 1);
        this.setSum(sum);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    public StatDesc getStatDesc() {
        return this.statDesc;
    }

    public void setStatDesc(StatDesc statDesc) {
        this.statDesc = statDesc;
    }

    @ManyToOne
    public StatTimeInterval getStatTimeInterval() {
        return this.timeInterval;
    }

    public void setStatTimeInterval(StatTimeInterval timeInterval) {
        this.timeInterval = timeInterval;
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double average) {
        this.average = average;
    }

    public double getSum2() {
        return this.sum2;
    }

    public void setSum2(double sum2) {
        this.sum2 = sum2;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setMin(double min) {
        this.minval = min;
    }

    @Column(name="minval")
    public double getMin() {
        return this.minval;
    }

    public void setMax(double max) {
        this.maxval = max;
    }

    @Column(name="maxval")
    public double getMax() {
        return this.maxval;
    }
}

